/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.oracle;

import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.search.MDMTable;
import com.tandbergtv.metadatamanager.util.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.jdbc.Work;
import org.w3c.dom.Document;

public class UpdateMetadata
implements Work {
    private static final String SQL_COMMON_1 = "]' PASSING object_value AS \"p\")";
    protected static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    protected String strXml;
    protected Document ecmfDoc;
    protected long documentId;
    protected boolean isNewRevision;
    protected boolean isOriginal;

    public UpdateMetadata(long documentId, Document ecmfDoc, boolean isNewRevision, boolean isOriginal) throws MetadataException {
        this.ecmfDoc = ecmfDoc;
        this.documentId = documentId;
        this.isNewRevision = isNewRevision;
        this.isOriginal = isOriginal;
        this.strXml = Utils.serialize(ecmfDoc);
        if (this.strXml == null || this.strXml.isEmpty()) {
            throw new MetadataException("Error: Empty Document");
        }
    }

    protected String getInsertSelectSql(long documentId) {
        if (!this.isNewRevision) {
            return null;
        }
        StringBuilder s = new StringBuilder("INSERT into ");
        s.append(MDMTable.REVISION.getTableName());
        s.append(" (object_value)");
        s.append(" select object_value from ");
        s.append(this.isOriginal ? MDMTable.MASTER.getTableName() : MDMTable.COPY.getTableName());
        s.append(" mdm");
        s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(documentId);
        s.append("]' PASSING mdm.object_value AS \"p\")");
        return s.toString();
    }

    protected String getUpdateSql() {
        StringBuilder s = new StringBuilder("UPDATE ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" SET object_value = ?  WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(this.documentId);
        s.append(SQL_COMMON_1);
        return s.toString();
    }

    public void execute(Connection con) throws SQLException {
        String insSelSql = this.getInsertSelectSql(this.documentId);
        if (StringUtils.isNotEmpty((String)insSelSql)) {
            this.exeInsertSelect(con, insSelSql);
        }
        this.exeUpdate(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exeUpdate(Connection con) throws SQLException {
        Statement st = null;
        SQLXML xmlObj = null;
        try {
            String updSql = this.getUpdateSql();
            logger.debug((Object)updSql);
            st = con.prepareStatement(updSql);
            xmlObj = con.createSQLXML();
            xmlObj.setString(this.strXml);
            st.setSQLXML(1, xmlObj);
            st.executeUpdate();
        }
        finally {
            if (xmlObj != null) {
                xmlObj.free();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    protected void exeInsertSelect(Connection con, String insSelSql) throws SQLException {
        logger.debug((Object)insSelSql);
        try (PreparedStatement st = con.prepareStatement(insSelSql);){
            st.execute();
        }
    }

    public String getXMLString() {
        return this.strXml;
    }
}

