/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.pg;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.oracle.InsertMetadata;
import com.tandbergtv.metadatamanager.search.MDMTable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import org.w3c.dom.Document;

public class PgInsertMetadata
extends InsertMetadata {
    public PgInsertMetadata(boolean isOriginal, Document ecmfDoc) throws MetadataException {
        super(isOriginal, ecmfDoc);
    }

    @Override
    protected String getSql() {
        StringBuilder s = new StringBuilder("INSERT into ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append("(document_id, document) VALUES (?,?)");
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection con) throws SQLException {
        Statement st = null;
        SQLXML xmlObj = null;
        try {
            String sql = this.getSql();
            logger.debug((Object)sql);
            st = con.prepareStatement(sql);
            String docId = this.ecmfDoc.getDocumentElement().getAttribute("documentId");
            st.setLong(1, Long.parseLong(docId));
            xmlObj = con.createSQLXML();
            xmlObj.setString(this.strXml);
            st.setSQLXML(2, xmlObj);
            st.execute();
        }
        finally {
            if (xmlObj != null) {
                xmlObj.free();
            }
            if (st != null) {
                st.close();
            }
        }
    }
}

