/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.assetkey.AssetKeyHandler;
import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.QueryBuilderFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class AssetSearchServiceImpl
implements AssetSearchService {
    private HibernateTemplate hibernateTemplate;
    private QueryBuilderFactory queryBuilderFactory;
    private IdDAO assetIdDAO;
    private static final Logger logger = Logger.getLogger(AssetSearchServiceImpl.class);

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setQueryBuilderFactory(QueryBuilderFactory factory) {
        this.queryBuilderFactory = factory;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public void setAssetIdDAO(IdDAO assetIdDAO) {
        this.assetIdDAO = assetIdDAO;
    }

    private List<Long> executeQuery(final String queryStr) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet results = statement.executeQuery();
                    while (results.next()) {
                        ids.add(results.getLong(1));
                    }
                }
            }
        };
        this.doWork(work);
        return ids;
    }

    private void doWork(Work work) {
        Session session = this.hibernateTemplate.getSessionFactory().openSession();
        try {
            session.doWork(work);
        }
        catch (RuntimeException e) {
            try {
                session.cancelQuery();
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
            throw e;
        }
        session.close();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public List<Document> search(SearchCriteria assetKeyMap) {
        AssetKeyHandler akHandler = new AssetKeyHandler(this.assetIdDAO);
        Long start = System.currentTimeMillis();
        List<Document> docs = akHandler.searchForFullDoc(assetKeyMap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchForFullDoc t=" + (System.currentTimeMillis() - start) + " ms"));
        }
        return docs;
    }

    @Override
    public Collection<Long> searchForDocId(SearchCriteria keyMap) {
        AssetKeyHandler akHandler = new AssetKeyHandler(this.assetIdDAO);
        Long start = System.currentTimeMillis();
        Collection<Long> ids = akHandler.searchForDocId(keyMap);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchForDocId t=" + (System.currentTimeMillis() - start) + " ms"));
        }
        return ids;
    }

    @Override
    @Transactional
    public List<String> getFieldValuesFromForRevision(String path, Long documentId) {
        return this.getFieldValuesHelper(path, documentId, "mdm_metadata_revision");
    }

    @Override
    @Transactional
    public List<String> getFieldValues(String fieldXpath, Long documentId) {
        return this.getFieldValuesHelper(fieldXpath, documentId, "mdm_metadata");
    }

    private List<String> getFieldValuesHelper(String path, Long documentId, String tableName) {
        final String queryStr = this.queryBuilderFactory.getAssetSearchQueryBuilder().buildGetFieldValuesQuery(path, documentId, tableName);
        logger.debug((Object)queryStr);
        final ArrayList<String> results = new ArrayList<String>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                try (PreparedStatement statement = conn.prepareStatement(queryStr);){
                    ResultSet resultSet = statement.executeQuery();
                    while (resultSet.next()) {
                        results.add(resultSet.getString(1));
                    }
                }
            }
        };
        this.doWork(work);
        return results;
    }
}

