/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.oracle;

import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.ParamType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.oracle.ConditionBuilder;

public class BooleanConditionBuilder
extends ConditionBuilder {
    public BooleanConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    private void validateBoolean() throws IllegalArgumentException {
        ParamType paramType = this.predicate.getOperator().getParamType();
        if (paramType.equals((Object)ParamType.RANGE) || paramType.equals((Object)ParamType.VALUE) || paramType.equals((Object)ParamType.LIST)) {
            PredicateRightValue prv = (PredicateRightValue)this.predicate;
            for (String value : prv.getValue()) {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) continue;
                throw new IllegalArgumentException("Unable to accurately parse " + value + " to a booean.");
            }
        }
    }

    @Override
    protected String equal() {
        this.validateBoolean();
        return this.buildConditon();
    }

    @Override
    protected String notEqual() {
        this.validateBoolean();
        return this.buildConditon();
    }

    private String buildConditon() {
        String xpathMinusTail;
        StringBuffer condition = new StringBuffer(this.getXmlExistsStart());
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustFieldName() + " and ";
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append("fn:string(");
        condition.append(xpathTail);
        condition.append(")=\"");
        condition.append(this.comparison());
        condition.append("\"]");
        condition.append(this.getXmlExistsEnd());
        return condition.toString();
    }

    private String comparison() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        boolean rhsValue = Boolean.parseBoolean((String)prv.getValue().get(0));
        if (prv.getNot() ^ prv.getOperator().equals((Object)LogicalOperator.NOTEQUAL)) {
            return Boolean.toString(!rhsValue);
        }
        return Boolean.toString(rhsValue);
    }
}

