/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.oracle;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.oracle.BooleanConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.DateConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.NumberConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.StringConditionBuilder;
import com.tandbergtv.metadatamanager.search.oracle.TimeConditionBuilder;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;

public class ConditionBuilder {
    private SearchSchemaHelper searchSchemaHelper;
    protected Predicate predicate;
    private String xmlExistsStart;
    private String xmlExistsEnd;
    private String xmlQueryForCustomField;
    private String xmlQueryReturn;
    private String xmlContains;
    private String xmlDateFormat;
    private String xmlTimeFormat;
    private String startsWithFunc;
    private String pathPrefix;
    private String xmlContainsEnds;

    public ConditionBuilder(Predicate predicate) {
        this.predicate = predicate;
    }

    public String getXmlExistsStart() {
        return this.xmlExistsStart;
    }

    public void setXmlExistsStart(String xmlExistsStart) {
        this.xmlExistsStart = xmlExistsStart;
    }

    public String getXmlExistsEnd() {
        return this.xmlExistsEnd;
    }

    public void setXmlExistsEnd(String xmlExistsEnd) {
        this.xmlExistsEnd = xmlExistsEnd;
    }

    public String getXmlQueryForCustomField() {
        return this.xmlQueryForCustomField;
    }

    public void setXmlQueryForCustomField(String xmlQueryForCustomField) {
        this.xmlQueryForCustomField = xmlQueryForCustomField;
    }

    public String getXmlQueryReturn() {
        return this.xmlQueryReturn;
    }

    public String getXmlDateFormat() {
        return this.xmlDateFormat;
    }

    public void setXmlDateFormat(String xmlDateFormat) {
        this.xmlDateFormat = xmlDateFormat;
    }

    public String getXmlTimeFormat() {
        return this.xmlTimeFormat;
    }

    public void setXmlTimeFormat(String xmlTimeFormat) {
        this.xmlTimeFormat = xmlTimeFormat;
    }

    public String getStartsWithFunc() {
        return this.startsWithFunc;
    }

    public void setStartsWithFunc(String startsWithFunc) {
        this.startsWithFunc = startsWithFunc;
    }

    public void setXmlQueryReturn(String xmlQueryReturn) {
        this.xmlQueryReturn = xmlQueryReturn;
    }

    public SearchSchemaHelper getSearchSchemaHelper() {
        return this.searchSchemaHelper;
    }

    public void setSearchSchemaHelper(SearchSchemaHelper searchSchemaHelper) {
        this.searchSchemaHelper = searchSchemaHelper;
    }

    public String getXmlContains() {
        return this.xmlContains;
    }

    public void setXmlContains(String xmlContains) {
        this.xmlContains = xmlContains;
    }

    protected boolean isCustomField() {
        return this.predicate.getFieldLeft().startsWith("/Fields/CustomFields/CustomField[@name=");
    }

    protected String getCustFieldName() {
        if (this.isCustomField()) {
            String field = this.predicate.getFieldLeft();
            return "@name=\"" + field.substring(39, field.indexOf("]")) + "\"";
        }
        return "";
    }

    protected String getCustomFieldXpath() {
        return this.getXpathStart() + "/Fields/CustomFields/CustomField";
    }

    protected String getCustomCriteria() {
        return this.getCustFieldName() + " and ";
    }

    protected String getRhsValue(int index) {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return SearchSchemaHelper.encodeValue((String)prv.getValue().get(index));
    }

    protected int getRhsValueCount() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue().size();
    }

    protected List<String> getValues() {
        PredicateRightValue prv = (PredicateRightValue)this.predicate;
        return prv.getValue();
    }

    protected String getFullXpath() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        String fieldLeft = this.predicate.getFieldLeft();
        if (this.isCustomField()) {
            fieldLeft = CustomFieldXPathConverter.getActualXpath(fieldLeft);
        }
        if (!fieldLeft.startsWith("/") && !fieldLeft.isEmpty()) {
            sb.append("/");
        }
        sb.append(fieldLeft);
        return sb.toString();
    }

    protected String getDollarPXpath() {
        return this.getPathPrefix() + this.getFullXpath();
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    protected String getXpathStart() {
        return this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true);
    }

    protected String getXpathMinusTail() {
        StringBuffer sb = new StringBuffer(this.getXpathStart());
        String fieldLeft = this.predicate.getFieldLeft();
        int stopIndex = fieldLeft.lastIndexOf("/");
        sb.append(fieldLeft.substring(0, stopIndex));
        if (stopIndex == 0 && this.predicate.fieldLeftIsWildCard()) {
            sb.append("/*");
        }
        return sb.toString();
    }

    protected String getXpathTail() {
        String fieldLeft = this.predicate.getFieldLeft();
        if (this.isCustomField()) {
            fieldLeft = CustomFieldXPathConverter.getActualXpath(fieldLeft);
        }
        int startIndex = fieldLeft.lastIndexOf("/") + 1;
        return fieldLeft.substring(startIndex);
    }

    protected String isEmpty() {
        StringBuilder condition = new StringBuilder();
        if (this.predicate.getFieldLeftSectionType().endsWith("ECMFSpec") && this.predicate.getFieldLeft().startsWith("/@")) {
            condition.append("not(");
            condition.append(this.getXmlExistsStart());
            condition.append(this.getFullXpath());
            condition.append(this.getXmlExistsEnd());
            condition.append(")");
            return condition.toString();
        }
        if (this.isCustomField()) {
            condition.append(this.getCustomFieldXMLQuery());
            condition.append(") is null ");
        } else {
            condition.append(this.getXmlContains());
            condition.append(this.getFullXpath());
            condition.append(this.getXmlContainsEnds());
            condition.append("=0 ");
        }
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" AND  not(");
            condition.append(this.getXmlExistsStart());
            condition.append(this.getXpathStart());
            condition.append("/UnparsableFields/UnparsableField");
            condition.append("[");
            condition.append(this.getStartsWithFunc());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(this.getXmlExistsEnd());
            condition.append("))");
        }
        return condition.toString();
    }

    private String getCustomFieldXMLQuery() {
        StringBuilder condition = new StringBuilder();
        condition.append(this.getXmlQueryForCustomField());
        condition.append(this.getDollarPXpath());
        condition.append("'");
        condition.append(this.getXmlQueryReturn());
        return condition.toString();
    }

    protected String isNotEmpty() {
        StringBuffer condition = new StringBuffer();
        if (this.predicate.getFieldLeftSectionType().endsWith("ECMFSpec") && this.predicate.getFieldLeft().startsWith("/@")) {
            condition.append(this.getXmlExistsStart());
            condition.append(this.getFullXpath());
            condition.append(this.getXmlExistsEnd());
            return condition.toString();
        }
        if (this.isCustomField()) {
            condition.append(this.getCustomFieldXMLQuery());
            condition.append(") is not null ");
        } else {
            condition.append(this.getXmlContains());
            condition.append(this.getFullXpath());
            condition.append(this.getXmlContainsEnds());
            condition.append(">0");
        }
        if (this.predicate.getFieldLeft().startsWith("/Fields")) {
            condition.insert(0, "(");
            condition.append(" OR ");
            condition.append(this.getXmlExistsStart());
            condition.append(this.getXpathStart());
            condition.append("/UnparsableFields/UnparsableField");
            condition.append("[");
            condition.append(this.getStartsWithFunc());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(this.getXmlExistsEnd());
            condition.append(")");
        }
        return condition.toString();
    }

    protected String containsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append(this.getXmlExistsStart());
        condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append("/UnparsableFields/UnparsableField");
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append(this.getStartsWithFunc());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(this.getXmlExistsEnd());
        } else {
            condition.append(this.getXmlExistsEnd());
            try {
                List<String> assetPaths = this.searchSchemaHelper.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" or ");
                    condition.append(this.getXmlExistsStart());
                    condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(assetPath, true));
                    condition.append("/UnparsableFields/UnparsableField");
                    condition.append(this.getXmlExistsEnd());
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String notContainsUnparsable() {
        StringBuffer condition = new StringBuffer();
        condition.append("not(");
        condition.append(this.getXmlExistsStart());
        condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(this.predicate.getFieldLeftSectionType(), true));
        condition.append("/UnparsableFields/UnparsableField");
        if (!this.predicate.getFieldLeft().isEmpty()) {
            condition.append("[");
            condition.append(this.getStartsWithFunc());
            condition.append("(");
            condition.append("@xpath");
            condition.append(", \"");
            condition.append(this.predicate.getFieldLeft());
            condition.append("\")]");
            condition.append(this.getXmlExistsEnd());
            condition.append(")");
        } else {
            condition.append(this.getXmlExistsEnd());
            condition.append(")");
            try {
                List<String> assetPaths = this.searchSchemaHelper.getChildAssetTypes(this.predicate.getFieldLeftSectionType());
                for (String assetPath : assetPaths) {
                    condition.append(" and not(");
                    condition.append(this.getXmlExistsStart());
                    condition.append(this.searchSchemaHelper.getEcmfComplientSectionType(assetPath, true));
                    condition.append("/UnparsableFields/UnparsableField");
                    condition.append(this.getXmlExistsEnd());
                    condition.append(")");
                }
                if (assetPaths.size() > 0) {
                    condition.insert(0, "(");
                    condition.append(")");
                }
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return condition.toString();
    }

    protected String contains() {
        throw this.getUnsupportedOp();
    }

    protected String endsWith() {
        throw this.getUnsupportedOp();
    }

    protected String equal() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThan() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThanEqual() {
        throw this.getUnsupportedOp();
    }

    protected String greaterThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String in() {
        throw this.getUnsupportedOp();
    }

    protected String lessThan() {
        throw this.getUnsupportedOp();
    }

    protected String lessThanEqual() {
        throw this.getUnsupportedOp();
    }

    protected String lessThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String notContains() {
        throw this.getUnsupportedOp();
    }

    protected String notEqual() {
        throw this.getUnsupportedOp();
    }

    protected String startsWith() {
        throw this.getUnsupportedOp();
    }

    protected String notIn() {
        throw this.getUnsupportedOp();
    }

    protected String notLessThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String notGreaterThanToday() {
        throw this.getUnsupportedOp();
    }

    protected String between() {
        throw this.getUnsupportedOp();
    }

    protected String doesNotEndWith() {
        throw this.getUnsupportedOp();
    }

    protected String doesNotStartWith() {
        throw this.getUnsupportedOp();
    }

    protected String equalToToday() {
        throw this.getUnsupportedOp();
    }

    protected String notEqualToToday() {
        throw this.getUnsupportedOp();
    }

    protected RuntimeException getUnsupportedOp() {
        return new RuntimeException("Unsupported Operation | xpath = " + this.predicate.getFieldLeft());
    }

    protected String simpleConditionHelper(String operator) {
        String xpathMinusTail;
        StringBuffer condition = new StringBuffer(this.getXmlExistsStart());
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustFieldName() + " and ";
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(this.getXpathTail());
        condition.append(operator);
        condition.append(this.getRhsValue(0));
        condition.append("]");
        condition.append(this.getXmlExistsEnd());
        return condition.toString();
    }

    protected String inHelper(String conjunction, String operator) {
        String xpathMinusTail;
        int valueCnt = this.getRhsValueCount();
        if (valueCnt == 0) {
            return "";
        }
        StringBuffer condition = new StringBuffer(this.getXmlExistsStart());
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        String xpathTail = this.getXpathTail();
        condition.append(xpathMinusTail);
        condition.append("[");
        if (!customCriteria.isEmpty()) {
            condition.append(customCriteria);
            condition.append("(");
        }
        for (int i = 0; i < valueCnt; ++i) {
            if (i > 0) {
                condition.append(" ");
                condition.append(conjunction);
                condition.append(" ");
            }
            condition.append(xpathTail);
            condition.append(operator);
            condition.append(this.getRhsValue(i));
        }
        if (!customCriteria.isEmpty()) {
            condition.append(")");
        }
        condition.append("]");
        condition.append(this.getXmlExistsEnd());
        return condition.toString();
    }

    private static ConditionBuilder getConditionBuilder(Predicate predicate) {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(predicate.getFieldLeft());
        if (dataType == null) {
            return new ConditionBuilder(predicate);
        }
        if (dataType.equals("integer") || dataType.equals("float")) {
            return new NumberConditionBuilder(predicate);
        }
        if (dataType.equals("string")) {
            return new StringConditionBuilder(predicate);
        }
        if (dataType.equals("time")) {
            return new TimeConditionBuilder(predicate);
        }
        if (dataType.equals("date")) {
            return new DateConditionBuilder(predicate);
        }
        if (dataType.equals("boolean")) {
            return new BooleanConditionBuilder(predicate);
        }
        return new ConditionBuilder(predicate);
    }

    public String getCondition() {
        switch (this.predicate.getSearchComplientOperator()) {
            case EQUAL: {
                return this.equal();
            }
            case NOTEQUAL: {
                return this.notEqual();
            }
            case LESSTHAN: {
                return this.lessThan();
            }
            case GREATERTHAN: {
                return this.greaterThan();
            }
            case LESSTHANEQUAL: {
                return this.lessThanEqual();
            }
            case GREATERTHANEQUAL: {
                return this.greaterThanEqual();
            }
            case ISNULL: {
                return this.isEmpty();
            }
            case ISNOTNULL: {
                return this.isNotEmpty();
            }
            case ISEMPTY: {
                return this.isEmpty();
            }
            case ISNOTEMPTY: {
                return this.isNotEmpty();
            }
            case CONTAINS: {
                return this.contains();
            }
            case DOESNOTCONTAIN: {
                return this.notContains();
            }
            case IN: {
                return this.in();
            }
            case NOTIN: {
                return this.notIn();
            }
            case STARTSWITH: {
                return this.startsWith();
            }
            case ENDSWITH: {
                return this.endsWith();
            }
            case DOESNOTSTARTWITH: {
                return this.doesNotStartWith();
            }
            case DOESNOTENDWITH: {
                return this.doesNotEndWith();
            }
            case GREATERTHANTODAY: {
                return this.greaterThanToday();
            }
            case LESSTHANTODAY: {
                return this.lessThanToday();
            }
            case EQUALTOTODAY: {
                return this.equalToToday();
            }
            case NOTEQUALTOTODAY: {
                return this.notEqualToToday();
            }
            case CONTAINSUNPARSABLE: {
                return this.containsUnparsable();
            }
            case DOESNOTCONTAINUNPARSABLE: {
                return this.notContainsUnparsable();
            }
            case NOTGREATERTHANTODAY: {
                return this.notGreaterThanToday();
            }
            case NOTLESSTHANTODAY: {
                return this.notLessThanToday();
            }
            case BETWEEN: {
                return this.between();
            }
        }
        throw new RuntimeException("Encountered the unsupported operator " + this.predicate.getSearchComplientOperator());
    }

    public static String getCondition(Predicate predicate) {
        ConditionBuilder conditionBuilder = ConditionBuilder.getConditionBuilder(predicate);
        return conditionBuilder.getCondition();
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setXmlContainsEnds(String xmlContainsEnds) {
        this.xmlContainsEnds = xmlContainsEnds;
    }

    public String getXmlContainsEnds() {
        return this.xmlContainsEnds;
    }
}

