/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.oracle;

import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.oracle.ConditionBuilder;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import java.util.List;

public class NumberConditionBuilder
extends ConditionBuilder {
    public NumberConditionBuilder(Predicate predicate) {
        super(predicate);
    }

    private void validateNumber() throws IllegalArgumentException {
        DataTypeMappingReader dtr = DataTypeMappingReader.getInstance();
        String dataType = dtr.determineDataType(this.predicate.getFieldLeft());
        if ("integer".equals(dataType)) {
            for (String value : this.getValues()) {
                Long.parseLong(value);
            }
        }
        if ("float".equals(dataType)) {
            for (String value : this.getValues()) {
                Float.parseFloat(value);
            }
        }
    }

    @Override
    protected String equal() {
        this.validateNumber();
        return this.simpleConditionHelper("=");
    }

    @Override
    protected String notEqual() {
        this.validateNumber();
        return this.simpleConditionHelper("!=");
    }

    @Override
    protected String greaterThan() {
        this.validateNumber();
        return this.simpleConditionHelper(">");
    }

    @Override
    protected String greaterThanEqual() {
        this.validateNumber();
        return this.simpleConditionHelper(">=");
    }

    @Override
    protected String lessThan() {
        this.validateNumber();
        return this.simpleConditionHelper("<");
    }

    @Override
    protected String lessThanEqual() {
        this.validateNumber();
        return this.simpleConditionHelper("<=");
    }

    @Override
    protected String in() {
        this.validateNumber();
        return this.inHelper("or", "=");
    }

    @Override
    protected String notIn() {
        this.validateNumber();
        return this.inHelper("and", "!=");
    }

    @Override
    protected String between() {
        String xpathMinusTail;
        this.validateNumber();
        List<String> values = this.getValues();
        StringBuffer condition = new StringBuffer(this.getXmlExistsStart());
        String xpathTail = this.getXpathTail();
        String customCriteria = "";
        if (this.isCustomField()) {
            xpathMinusTail = this.getCustomFieldXpath();
            customCriteria = this.getCustomCriteria();
        } else {
            xpathMinusTail = this.getXpathMinusTail();
        }
        condition.append(xpathMinusTail);
        condition.append("[");
        condition.append(customCriteria);
        condition.append(xpathTail);
        condition.append(">=");
        condition.append(values.get(0));
        condition.append(" and ");
        condition.append(xpathTail);
        condition.append("<=");
        condition.append(values.get(1));
        condition.append("]");
        condition.append(this.getXmlExistsEnd());
        return condition.toString();
    }
}

