/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search.pg;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.Predicate;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.metadatamanager.search.oracle.AssetSearchQueryBuilder;
import com.tandbergtv.metadatamanager.util.CustomFieldXPathConverter;
import com.tandbergtv.metadatamanager.util.DBTypeEnum;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;

public class PgAssetSearchQueryBuilder
extends AssetSearchQueryBuilder {
    public PgAssetSearchQueryBuilder(SearchSchemaHelper searchSchemaHelper) {
        super(searchSchemaHelper);
    }

    @Override
    public String buildQueryForFullDoc(ExpNode condition, boolean onlyOriginals) {
        StringBuffer query = new StringBuffer();
        query.append("select XMLSERIALIZE(content mdm.document as text) \r\n");
        query.append("from mdm_metadata mdm\r\n");
        query.append(this.buildWhere(condition, onlyOriginals, null));
        return query.toString();
    }

    @Override
    protected void buildCombinedCondition(StringBuffer query, ExpNode condition) {
        query.append(" xmlexists('");
        this.appendCombinedConditionPath(query, condition);
        query.append("passing document)");
    }

    @Override
    protected String getCustmFieldSelect(String assetType, String xpath) {
        StringBuffer sb = new StringBuffer();
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        sb.append("(xpath('");
        this.appendCustomFieldSelectPath(sb, assetType, xpath);
        sb.append("', mdm.document))[1]::text");
        if (dataType.equals("date")) {
            sb.append("::timestamp without time zone");
        }
        return sb.toString();
    }

    @Override
    protected String getFieldSelectWithCond(String assetType, String xpath) {
        StringBuffer result = new StringBuffer();
        result.append("(xmlpath('");
        this.appendFieldWithCond(assetType, xpath, result);
        result.append("', mdm.document))[1]::VARCHAR2(2000))");
        return result.toString();
    }

    @Override
    public String getExtractValue(String assetType, String xpath) {
        if (SearchSchemaHelper.isCustomField(xpath)) {
            return this.getCustmFieldSelect(assetType, xpath);
        }
        if (xpath.contains("[")) {
            return this.getFieldSelectWithCond(assetType, xpath);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(xpath('");
        sb.append(this.getDisplayXpath(assetType, xpath));
        if (xpath.indexOf(64) == -1) {
            sb.append("/text()");
        }
        sb.append("', mdm.document))[1]::text");
        String dataType = DataTypeMappingReader.getInstance().determineDataType(xpath);
        if (dataType.equals("date")) {
            sb.append("::timestamp without time zone");
        }
        return sb.toString();
    }

    @Override
    protected String getCondition(Predicate predicate) {
        return this.getConditionBuilderFactory().getCondition(DBTypeEnum.POSTGRESQL, predicate);
    }

    @Override
    public String getMultiValueSelect(String assetType, String xpath) {
        StringBuffer sb = new StringBuffer();
        sb.append("array_to_string(xpath('");
        if (!xpath.startsWith("/")) {
            sb.append("*");
        }
        sb.append(this.searchSchemaHelper.getEcmfComplientSectionTypeWIndices(assetType, true));
        if (SearchSchemaHelper.isCustomField(xpath)) {
            sb.append(CustomFieldXPathConverter.getActualXpath(xpath));
        } else {
            sb.append(xpath);
        }
        if (sb.indexOf("@") == -1) {
            sb.append("/text()");
        }
        sb.append("', document), ',', '')");
        return sb.toString();
    }

    @Override
    public String buildGetFieldValuesQuery(String path, Long documentId, String tableName) {
        StringBuffer query = new StringBuffer("select unnest(xpath('");
        query.append(path);
        query.append("', document))::text as value ");
        query.append(" from ").append(tableName);
        query.append(" where document_id = ");
        query.append(documentId);
        return query.toString();
    }

    @Override
    protected String getAssetCondition(Predicate predicate) {
        return this.getConditionBuilderFactory().getAssetCondition(DBTypeEnum.POSTGRESQL, predicate);
    }

    @Override
    public void joinOntoMdm(StringBuffer query) {
        query.append(" \r\n");
        query.append("JOIN mdm_metadata ");
        query.append("mdm");
        query.append("\r\nON (");
        query.append(" t.mdmdocid   = mdm.document_id");
    }
}

