/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import java.io.InputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;

public class SchemaValidator {
    private static SchemaValidator instance = null;
    private static ValidatorThreadLocal validatorHolder = new ValidatorThreadLocal();
    private static String xsdResource = "/com/tandbergtv/metadatamanager/specimpl/ttv/schema/ECMFSpec.xsd";

    private SchemaValidator() {
    }

    public static synchronized SchemaValidator getInstance() {
        if (instance == null) {
            instance = new SchemaValidator();
        }
        return instance;
    }

    public boolean validate(Document xmlDoc) throws MetadataException {
        try {
            String noNamespaceSchemaLoc = xmlDoc.getDocumentElement().getAttribute("xsi:noNamespaceSchemaLocation");
            if (noNamespaceSchemaLoc != null) {
                xmlDoc.getDocumentElement().removeAttribute("xsi:noNamespaceSchemaLocation");
            }
            DOMSource src = new DOMSource(xmlDoc);
            Validator v = (Validator)validatorHolder.get();
            v.validate(src);
            if (noNamespaceSchemaLoc != null) {
                xmlDoc.getDocumentElement().setAttribute("xsi:noNamespaceSchemaLocation", noNamespaceSchemaLoc);
            }
            return true;
        }
        catch (Exception ex) {
            throw new MetadataException(ex.getMessage(), ex);
        }
    }

    private static class ValidatorThreadLocal
    extends ThreadLocal<Validator> {
        @Override
        protected Validator initialValue() {
            Validator validator;
            try {
                XMLSchemaFactory factory = new XMLSchemaFactory();
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(xsdResource);
                Schema schema = factory.newSchema(new StreamSource(is));
                validator = schema.newValidator();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return validator;
        }
    }
}

