/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.ericsson.cms.criteria.ExpList;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.IRuleManager;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.specimpl.AssetValidator;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import com.tandbergtv.metadatamanager.validation.Schema.SchemaValidator;
import com.tandbergtv.metadatamanager.validation.Schematron.CustomSchematronBuilder;
import com.tandbergtv.metadatamanager.validation.Schematron.SchematronValidator;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class SpecHandlerBase
implements ISpecHandler {
    public static final String EMPTY_STRING_VALUE = "";
    private static final String SCHEMA_VALIDATOR = "SchemaValidator";
    protected MetadataManagerDAO metadataManagerDAO;
    protected AssetSearchService searchService;
    protected final Logger logger = Logger.getLogger(SpecHandlerBase.class);
    protected ITranslator toTTV;
    protected ITranslator fromTTV;
    protected URL mappingResourceUrl;
    protected Map<String, IValidator> ruleValidators;
    protected String schemaResource;
    @Deprecated
    protected Spec spec;
    protected String rootElementName;
    protected IRuleManager ruleManager;
    protected Map<String, Set<String>> specSpecificTTVXpaths;
    protected InputStream specSpecificTTVXpathsStream;
    protected String alias;

    @Override
    public String getSpecDisplayName() {
        return this.alias;
    }

    @Override
    public void setRuleManager(IRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    @Override
    public IRuleManager getRuleManager() {
        return this.ruleManager;
    }

    @Deprecated
    public Spec getSpec() {
        return null;
    }

    @Deprecated
    public void setSpec(Spec spec) {
    }

    public String getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(String schemaResource) {
        this.schemaResource = schemaResource;
    }

    @Override
    public Map<String, IValidator> getRuleValidators() {
        return this.ruleValidators;
    }

    @Override
    public void setRuleValidators(Map<String, IValidator> validators) {
        this.ruleValidators = validators;
    }

    public URL getMappingResourceUrl() {
        return this.mappingResourceUrl;
    }

    @Override
    public void setMappingResourceUrl(URL mappingResourceUrl) {
        this.mappingResourceUrl = mappingResourceUrl;
    }

    @Override
    public ITranslator getToTTV() {
        return this.toTTV;
    }

    @Override
    public void setToTTV(ITranslator toTTV) {
        this.toTTV = toTTV;
    }

    @Override
    public ITranslator getFromTTV() {
        return this.fromTTV;
    }

    @Override
    public void setFromTTV(ITranslator fromTTV) {
        this.fromTTV = fromTTV;
    }

    public MetadataManagerDAO getMetadataManagerDAO() {
        return this.metadataManagerDAO;
    }

    public void setMetadataManagerDAO(MetadataManagerDAO metadataManagerDAO) {
        this.metadataManagerDAO = metadataManagerDAO;
    }

    @Override
    public AssetSearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void setSpecSpecificTTVXpathsStream(InputStream specSpecificTTVXpathsStream) {
        this.specSpecificTTVXpathsStream = specSpecificTTVXpathsStream;
        BufferedReader br = new BufferedReader(new InputStreamReader(specSpecificTTVXpathsStream));
        this.specSpecificTTVXpaths = new HashMap<String, Set<String>>();
        try {
            String line;
            String type = EMPTY_STRING_VALUE;
            HashSet set = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(EMPTY_STRING_VALUE)) continue;
                if (line.startsWith("[")) {
                    type = line.replaceAll("\\[", EMPTY_STRING_VALUE);
                    type = type.replaceAll("\\]", EMPTY_STRING_VALUE);
                    if (this.specSpecificTTVXpaths.containsKey(type = type.trim().toLowerCase())) continue;
                    set = new HashSet();
                    this.specSpecificTTVXpaths.put(type, set);
                    continue;
                }
                this.specSpecificTTVXpaths.get(type).add(line.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Unable to close reader ", (Throwable)ex);
            }
        }
    }

    public Map<String, Set<String>> getSpecSpecificTTVXpaths() {
        return this.specSpecificTTVXpaths;
    }

    @Override
    @Transactional
    public List<IIdentifier> deleteAll(List<IIdentifier> ids) {
        ArrayList<IIdentifier> deletedAssetIds = new ArrayList<IIdentifier>();
        for (IIdentifier id : ids) {
            try {
                this.deleteUnique(id);
                deletedAssetIds.add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error deleting asset with id: " + id.toString()), (Throwable)e);
            }
        }
        return deletedAssetIds;
    }

    @Override
    @Transactional
    public void deleteUnique(IIdentifier id) throws SearchException {
        Asset asset = id.getAsset();
        this.logger.debug((Object)("Deleting asset - TTV Id for: " + id.toString() + " is = " + asset.getId()));
        this.metadataManagerDAO.delete(asset);
    }

    protected Document kludge(Document doc) {
        if (doc == null) {
            return null;
        }
        DocumentBuilder builder = null;
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer(baos, format);
            serializer.serialize(doc);
            byte[] docBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(docBytes);
            builder = XmlUtil.borrowDocumentBuilder();
            return builder.parse(bais);
        }
        catch (IOException | SAXException e) {
            this.logger.warn((Object)e);
            return null;
        }
    }

    @Override
    public Document get(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        return this.get(id, null);
    }

    @Override
    @Transactional
    public List<IIdentifier> getIdentifiers(Document doc) throws MetadataException {
        this.logger.debug((Object)"Trying to extract identifiers from the given document");
        ArrayList<IIdentifier> returnIdentifierList = new ArrayList<IIdentifier>();
        try {
            List<Asset> assets = this.convertDocumentToAssets(doc);
            if (assets != null) {
                for (Asset a : assets) {
                    IIdentifier identifier = this.extractId(a);
                    returnIdentifierList.add(identifier);
                }
            }
        }
        catch (Exception ex) {
            throw new MetadataException(ex.getMessage(), ex);
        }
        return returnIdentifierList;
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc) throws MetadataException {
        return this.put(doc, null, null, null);
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        this.logger.debug((Object)"In put()");
        RootAssetRevision rootAssetRevision = new RootAssetRevision(revisionSource, revisionComment, externalRevision);
        boolean prune = true;
        List<Asset> assetList = this.save(doc, prune, rootAssetRevision);
        ArrayList<IIdentifier> savedIdList = new ArrayList<IIdentifier>();
        for (Asset ma : assetList) {
            savedIdList.add(this.extractId(ma));
        }
        return savedIdList;
    }

    @Override
    @Transactional
    public List<Asset> save(Document doc) throws MetadataException {
        boolean prune = true;
        return this.save(doc, prune, new RootAssetRevision());
    }

    private List<Asset> save(Document doc, boolean prune, RootAssetRevision rootAssetRevision) throws MetadataException {
        List<Asset> assets = this.convertDocumentToAssets(doc);
        return this.mergeSaveAssets(assets, prune, rootAssetRevision, false, false);
    }

    private List<Asset> convertDocumentToAssets(Document doc) throws MetadataException {
        Document convertedDoc = null;
        try {
            convertedDoc = this.getToTTV().translate(doc);
        }
        catch (TranslationException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        String rootNodeName = convertedDoc.getDocumentElement().getNodeName();
        List<Asset> assets = "ECMFSpec".equals(rootNodeName) ? new ECMFBinder().bind(convertedDoc) : new Binder().bind(convertedDoc);
        return assets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Asset> mergeSaveAssets(List<Asset> toBeMergedAssets, boolean prune, RootAssetRevision rootAssetRevision, boolean isRollback, boolean saveAsDraft) throws MetadataException {
        List<Asset> mergedAssets;
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        rootAssetRevision.setDraft(saveAsDraft);
        AssetValidator validator = new AssetValidator(this);
        for (Asset asset : toBeMergedAssets) {
            validator.validate(asset);
        }
        try {
            mergedAssets = this.mergeAssets(toBeMergedAssets, prune, true);
        }
        catch (SearchException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        ArrayList<Asset> savedAssetList = new ArrayList<Asset>();
        Iterator<Asset> iterator = mergedAssets.iterator();
        while (true) {
            boolean addRootAssetRevision;
            Group group;
            block13: {
                boolean newAsset;
                if (!iterator.hasNext()) {
                    return assetList;
                }
                Asset ma = iterator.next();
                assetList.add(ma);
                if (!(ma instanceof Group)) continue;
                group = (Group)ma;
                addRootAssetRevision = true;
                boolean bl = newAsset = !group.getTTVId().isValidIdentifier();
                if (saveAsDraft && !group.isRevisionNumberUpdated()) {
                    this.logger.info((Object)("Saving group(" + group.getId() + "), from non-draft to draft, increment RooAssetRevision by 1, although no changes are made."));
                    group.setLatestRevisionNumber(group.getLatestRevisionNumber() + 1);
                } else {
                    if (!(isRollback || group.isRevisionNumberUpdated() || newAsset)) {
                        if (group.isOriginalRevisionChanged()) {
                            addRootAssetRevision = false;
                            break block13;
                        } else {
                            this.logger.info((Object)("No new changes made to Asset:" + group + ", abort saving a new revision!"));
                            continue;
                        }
                    }
                    if (isRollback && !group.isRevisionNumberUpdated()) {
                        group.setLatestRevisionNumber(group.getLatestRevisionNumber() + 1);
                    }
                }
            }
            if (addRootAssetRevision) {
                group.addRootAssetRevision(rootAssetRevision);
            }
            RootAssetRevision existingRootAssetRevision = group.getLatestRootAssetRevision();
            existingRootAssetRevision.setDraft(saveAsDraft);
            long t1 = System.currentTimeMillis();
            this.getMetadataManagerDAO().validateAssetKeys(group);
            long t2 = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("***************** MetadataManagerDAO.validateAssetKeysForPersistence = " + (t2 - t1) + " ms"));
            }
            Asset savedAsset = this.getMetadataManagerDAO().saveAsset(group);
            savedAssetList.add(savedAsset);
            long t3 = System.currentTimeMillis();
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("***************** MetadataManagerDAO.saveAsset = " + (t3 - t2) + " ms"));
        }
    }

    @Override
    @Transactional
    public List<Asset> incrementalSave(Document doc) throws MetadataException {
        boolean prune = false;
        return this.save(doc, prune, new RootAssetRevision());
    }

    @Override
    public List<ValidationError> validateSchema(Document doc) {
        SchemaValidator validator = new SchemaValidator(this.getSchemaValidatorName(), this.schemaResource);
        return validator.validate(doc);
    }

    @Override
    public List<ValidationError> customValidate(Document doc, IValidator baseRules, String ruleSet) {
        List<ValidationError> errors = baseRules.validate(doc);
        Map<String, Boolean> ruleMap = this.ruleManager.getRuleSet(ruleSet);
        errors = this.removeOverridenErrors(errors, ruleMap);
        errors.addAll(this.addRequiredErrors(doc, ruleMap));
        return errors;
    }

    private List<ValidationError> addRequiredErrors(Document doc, Map<String, Boolean> ruleMap) {
        InputStream is = CustomSchematronBuilder.buildSchematron(ruleMap);
        SchematronValidator customValidator = new SchematronValidator("custom", is);
        return customValidator.validate(doc);
    }

    private List<ValidationError> removeOverridenErrors(List<ValidationError> errors, Map<String, Boolean> ruleMap) {
        ArrayList<ValidationError> toDelete = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            if (!"ERR-02".equals(ve.getErrorCode()) || !this.errorFoundInMap(ve, ruleMap)) continue;
            toDelete.add(ve);
        }
        for (ValidationError ve : toDelete) {
            errors.remove(ve);
        }
        return errors;
    }

    private boolean errorFoundInMap(ValidationError ve, Map<String, Boolean> ruleMap) {
        for (Map.Entry<String, Boolean> entry : ruleMap.entrySet()) {
            try {
                if (!this.compareXPaths(entry.getKey(), ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                return true;
            }
            catch (IndexOutOfBoundsException e) {
                this.logger.debug((Object)e);
            }
        }
        return false;
    }

    private boolean compareXPaths(String string1, String string2) {
        String str1 = string1.replaceAll("\\[[0-9]*\\]|@", EMPTY_STRING_VALUE);
        String str2 = string2.replaceAll("\\[[0-9]*\\]|@", EMPTY_STRING_VALUE);
        return str1.equals(str2);
    }

    @Override
    public List<ValidationError> validateField(Document doc, IValidator baseRules, String xpath) {
        List<ValidationError> errors = baseRules.validate(doc);
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            try {
                if (!this.compareXPaths(xpath, ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                results.add(ve);
            }
            catch (IndexOutOfBoundsException e) {
                this.logger.debug((Object)e);
            }
        }
        return results;
    }

    private String getSchemaValidatorName() {
        return this.getSpec().toString() + SCHEMA_VALIDATOR;
    }

    private List<Asset> mergeAssets(List<Asset> assets, boolean prune, boolean createRevision) throws SearchException, MetadataException {
        Iterator<Asset> assetIter = assets.iterator();
        ArrayList<Asset> mergedAssets = new ArrayList<Asset>();
        while (assetIter.hasNext()) {
            Asset currAsset = assetIter.next();
            if ((currAsset = AssetUtil.deleteEmptyFields(currAsset)) instanceof Group) {
                NextRevision nextRevision = new NextRevision();
                TTVId existingTTVId = this.getTTVId(currAsset, null);
                Asset mergedAsset = currAsset;
                if (existingTTVId != null) {
                    Asset existingAsset = this.getMetadataManagerDAO().getAsset(existingTTVId);
                    if (createRevision) {
                        nextRevision.setRevisionNumber(existingAsset.getLatestRevisionNumber() + 1);
                    } else {
                        nextRevision = null;
                    }
                    mergedAsset = this.mergeAsset(currAsset, existingAsset, prune, nextRevision);
                    if (mergedAsset.getType().equals(Group.GroupType.PACKAGE.name())) {
                        Group pkg = (Group)mergedAsset;
                        List<Long> titleIds = ((Group)currAsset).getReferencedTitleIds();
                        ArrayList<Long> copy = new ArrayList<Long>();
                        if (titleIds != null) {
                            copy.addAll(titleIds);
                            pkg.setReferencedTitleIds(copy);
                        } else {
                            pkg.setReferencedTitleIds(null);
                        }
                    }
                } else {
                    AssetUtil.copyFieldsToFieldRevisions(mergedAsset, nextRevision);
                }
                mergedAssets.add(mergedAsset);
                continue;
            }
            throw new MetadataException("Adding an ITEM is not supported yet! Add a Group");
        }
        return mergedAssets;
    }

    protected Asset mergeAsset(Asset newAsset, Asset oldAsset, boolean prune, NextRevision nextRevision) throws SearchException {
        Asset rootAsset = oldAsset;
        oldAsset = this.mergeAndAddIncomingIntoExistingAsset(newAsset, oldAsset, rootAsset, nextRevision);
        if (prune) {
            oldAsset = this.pruneExistingAssetTree(newAsset, oldAsset, nextRevision);
        }
        return oldAsset;
    }

    protected Asset mergeAndAddIncomingIntoExistingAsset(Asset newAsset, Asset oldAsset, Asset rootAsset, NextRevision nextRevision) throws SearchException {
        if (newAsset == oldAsset) {
            return oldAsset;
        }
        String assetType = this.getAssetType(newAsset);
        if (newAsset.getOriginalRevisionNumber() != null) {
            oldAsset.setOriginalRevisionNumber(newAsset.getOriginalRevisionNumber());
        }
        this.mergeFields(newAsset, oldAsset, assetType, nextRevision);
        for (Relation newRelation : newAsset.getRelations()) {
            Asset newTargetAsset = newRelation.getTargetAsset();
            if (this.requireSpecSpecificMerging(this.getAssetType(newTargetAsset))) {
                this.specSpecificMerging(oldAsset, nextRevision, newRelation, newTargetAsset);
                continue;
            }
            this.mergeExistingTargetAsset(newTargetAsset, rootAsset, oldAsset, nextRevision);
        }
        return oldAsset;
    }

    protected void mergeExistingTargetAsset(Asset newTargetAsset, Asset rootAsset, Asset oldAsset, NextRevision nextRevision) throws SearchException {
        if (nextRevision == null) {
            NextRevision currentAssetRevision = new NextRevision();
            currentAssetRevision.setRevisionNumber(oldAsset.getLatestRevisionNumber());
        }
        boolean ifExistingTargetAsset = true;
        Asset existingTargetAsset = this.searchTargetAssetInMemory(newTargetAsset, rootAsset, oldAsset);
        if (existingTargetAsset == null) {
            ifExistingTargetAsset = false;
            if (nextRevision == null) {
                NextRevision rootAssetRevision = new NextRevision();
                rootAssetRevision.setRevisionNumber(this.getRootRevision(oldAsset));
                oldAsset.addChild(newTargetAsset, rootAssetRevision, true);
            } else {
                oldAsset.addChild(newTargetAsset, nextRevision, true);
            }
        }
        if (ifExistingTargetAsset) {
            this.mergeAndAddIncomingIntoExistingAsset(newTargetAsset, existingTargetAsset, rootAsset, nextRevision);
            if (nextRevision != null && existingTargetAsset.isRevisionNumberUpdated()) {
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            }
        }
    }

    protected Asset searchTargetAssetInMemory(Asset newTargetAsset, Asset rootAsset, Asset oldAsset) {
        SearchCriteria criteria = this.prepareSearchPathById(newTargetAsset.getFields());
        return oldAsset.getAsset(criteria);
    }

    protected void specSpecificMerging(Asset oldAsset, NextRevision nextRevision, Relation newRelation, Asset targetAsset) {
    }

    protected void specSpecificMergingNoSave(Asset oldAsset, Relation newRelation, Asset targetAsset) {
    }

    protected Asset pruneExistingAssetTree(Asset newAsset, Asset oldAsset, NextRevision nextRevision) throws SearchException {
        ArrayList<Relation> oldRelationsToBeDeleted = new ArrayList<Relation>();
        ArrayList<Asset> children = new ArrayList<Asset>();
        for (Relation oldRelation : oldAsset.getRelations()) {
            String oldTargetAssetType;
            Asset oldTargetAsset = oldRelation.getTargetAsset();
            if (oldTargetAsset.getTTVId().getId() <= 0L || !this.isAssetTypePartOfSpec(oldTargetAssetType = this.getAssetType(oldTargetAsset))) continue;
            Asset newTargetAsset = this.searchNewTargetAsset(oldTargetAssetType, newAsset, oldTargetAsset);
            if (newTargetAsset == null) {
                oldRelationsToBeDeleted.add(oldRelation);
                continue;
            }
            children.add(this.pruneExistingAssetTree(newTargetAsset, oldTargetAsset, nextRevision));
        }
        this.removeOldRelations(oldAsset, nextRevision, oldRelationsToBeDeleted);
        for (Asset childPlease : children) {
            if (nextRevision == null || childPlease.getLatestRevisionNumber() < nextRevision.getRevisionNumber()) continue;
            oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
        }
        return oldAsset;
    }

    protected Asset searchNewTargetAsset(String oldTargetAssetType, Asset newAsset, Asset oldTargetAsset) {
        Asset newTargetAsset = null;
        if (this.requireSpecSpecificSearchForPruning(oldTargetAssetType)) {
            newTargetAsset = this.specSpecificSearchForPruning(oldTargetAssetType, newAsset, oldTargetAsset);
        } else {
            SearchCriteria crit = this.prepareSearchPathById(oldTargetAsset.getFields());
            for (Relation rel : newAsset.getRelations()) {
                Asset currentTargetAsset = rel.getTargetAsset();
                List<Field> fields = currentTargetAsset.getFields();
                if (!this.isSearchCriteriaPresent(crit, fields)) continue;
                newTargetAsset = currentTargetAsset;
                break;
            }
        }
        return newTargetAsset;
    }

    protected boolean isAssetTypePartOfSpec(String assetType) {
        return this.specSpecificTTVXpaths.containsKey(assetType.toLowerCase());
    }

    protected void removeOldRelations(Asset oldAsset, NextRevision nextRevision, ArrayList<Relation> oldRelationsToBeDeleted) throws SearchException {
        boolean createRevision;
        boolean bl = createRevision = nextRevision != null;
        if (!createRevision) {
            nextRevision = new NextRevision();
            nextRevision.setRevisionNumber(oldAsset.getLatestRevisionNumber());
        }
        for (Relation oldRelationToBeDeleted : oldRelationsToBeDeleted) {
            oldRelationToBeDeleted.setDeleteRevision(nextRevision.getRevisionNumber());
            List<Field> oldTargetAssetFields = oldRelationToBeDeleted.getTargetAsset().getFields();
            oldTargetAssetFields.removeAll(oldTargetAssetFields);
        }
        if (!oldRelationsToBeDeleted.isEmpty() && createRevision) {
            oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
        }
        if (!oldRelationsToBeDeleted.isEmpty()) {
            List<Relation> oldRelations = oldAsset.getRelations();
            oldRelations.removeAll(oldRelationsToBeDeleted);
        }
    }

    protected Asset specSpecificSearchForPruning(String assetType, Asset newAsset, Asset oldTargetAsset) {
        return null;
    }

    protected boolean requireSpecSpecificSearchForPruning(String assetType) {
        return false;
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        return false;
    }

    protected String getAssetType(Asset targetAsset) {
        String assetType;
        if ((targetAsset = new AssetUtil().unWrap(targetAsset)) instanceof Group) {
            Group g = (Group)targetAsset;
            assetType = g.getType();
        } else {
            Item i = (Item)targetAsset;
            assetType = i.getType();
        }
        return assetType;
    }

    protected boolean isSearchCriteriaPresent(SearchCriteria criteria, List<Field> fields) {
        for (Map.Entry entry : criteria.entrySet()) {
            String xpath = (String)entry.getKey();
            String value = (String)entry.getValue();
            boolean fieldsFound = false;
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(xpath) || !f.getValue().equals(value)) continue;
                fieldsFound = true;
                break;
            }
            if (fieldsFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public TTVId getTTVId(Asset asset, Asset rootAsset) throws SearchException {
        IIdentifier identifier = this.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        return identifier.getAssetTTVId();
    }

    protected Map<String, String> translate(List<String> fields) {
        HashMap<String, String> fieldXpaths = new HashMap<String, String>();
        Map<String, String> fieldMappings = MappingFileParser.readFieldMapping(this.getMappingResourceUrl());
        for (String field : fields) {
            if (fieldMappings.containsKey(field)) {
                fieldXpaths.put(field, fieldMappings.get(field));
                continue;
            }
            throw new RuntimeException("Cannot map field: " + field + " to TTV equivalent.");
        }
        return fieldXpaths;
    }

    public SearchCriteria prepareSearchPathById(List<Field> fields) {
        SearchCriteria criteria = new SearchCriteria();
        IdentifierBase identifer = this.getIdentifier();
        identifer.setMappingResourceUrl(this.getMappingResourceUrl());
        Map<String, String> idPaths = identifer.getTTVPaths();
        Iterator<Map.Entry<String, String>> pathIter = idPaths.entrySet().iterator();
        while (pathIter.hasNext()) {
            boolean isEntryFound = false;
            Map.Entry<String, String> entry = pathIter.next();
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(entry.getValue())) continue;
                isEntryFound = true;
                criteria.put(entry.getValue(), f.getValue());
                break;
            }
            if (isEntryFound) continue;
            criteria.put(entry.getValue(), EMPTY_STRING_VALUE);
        }
        return criteria;
    }

    public void mergeFields(Asset newAsset, Asset oldAsset, String assetType, NextRevision nextRevision) {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        helper.setSpecKeyValueHasChanged(newAsset, oldAsset);
        List<Field> oldFields = oldAsset.getFields();
        List<FieldRevision> toBeDeletedFieldRevisions = this.getToBeDeleted(newAsset.getFieldsMap(), oldAsset.getFieldRevisions(), assetType);
        if (toBeDeletedFieldRevisions != null && !toBeDeletedFieldRevisions.isEmpty()) {
            if (nextRevision == null) {
                int rootRevision = this.getRootRevision(oldAsset);
                oldAsset.setLatestRevisionNumber(rootRevision);
                NextRevision nr = new NextRevision();
                nr.setRevisionNumber(rootRevision);
            } else {
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            }
        }
        List<Field> toBeDeletedFields = this.getToBeDeleted(newAsset.getFieldsMap(), oldFields, assetType);
        oldFields.removeAll(toBeDeletedFields);
        this.updateExistingFields(newAsset, oldAsset, nextRevision);
    }

    protected int getRootRevision(Asset asset) {
        int rootRevision = asset.getRoot() == null ? asset.getLatestRevisionNumber() : asset.getRoot().getLatestRevisionNumber();
        return rootRevision;
    }

    protected void updateExistingFields(Asset newAsset, Asset oldAsset, NextRevision nextRevision) {
        List<Field> newFields = newAsset.getFields();
        if (newFields == null) {
            return;
        }
        for (Field newField : newFields) {
            Field oldField;
            FieldRevision oldFieldRevision = this.getFieldForXpathAndIndex(oldAsset.getFieldRevisionsMap(), newField.getTtvXPath(), newField.getIndices());
            if (oldFieldRevision != null) {
                if (!newField.getValue().equals(oldFieldRevision.getValue())) {
                    if (nextRevision != null) {
                        FieldRevision newFieldRevision = new FieldRevision(oldFieldRevision, nextRevision);
                        newFieldRevision.setValue(newField.getValue());
                        oldAsset.addFieldRevision(newFieldRevision, nextRevision);
                    } else {
                        int rootRevision = this.getRootRevision(oldAsset);
                        if (oldFieldRevision.getRevisionNumber() >= rootRevision) {
                            oldFieldRevision.setValue(newField.getValue());
                        } else {
                            NextRevision nr = new NextRevision();
                            nr.setRevisionNumber(rootRevision);
                            FieldRevision newFieldRevision = new FieldRevision(oldFieldRevision, nr);
                            newFieldRevision.setValue(newField.getValue());
                            oldAsset.addFieldRevision(newFieldRevision, nr);
                        }
                    }
                }
            } else if (nextRevision == null) {
                NextRevision tempNextRevision = new NextRevision();
                int rootRevision = this.getRootRevision(oldAsset);
                tempNextRevision.setRevisionNumber(rootRevision);
                FieldRevision newf = new FieldRevision(newField, tempNextRevision);
                newf.setDeleteRevision(0);
                newf.setAddRevision(tempNextRevision.getRevisionNumber());
                newf.setRevisionNumber(tempNextRevision.getRevisionNumber());
                oldAsset.addFieldRevision(newf, tempNextRevision);
            } else {
                FieldRevision newf = new FieldRevision(newField, nextRevision);
                newf.setDeleteRevision(0);
                newf.setAddRevision(nextRevision.getRevisionNumber());
                newf.setRevisionNumber(nextRevision.getRevisionNumber());
                oldAsset.addFieldRevision(newf, nextRevision);
            }
            if ((oldField = this.getFieldForXpathAndIndex(oldAsset.getFieldsMap(), newField.getTtvXPath(), newField.getIndices())) != null) {
                oldField.setValue(newField.getValue());
                continue;
            }
            Field newf = new Field(newField);
            oldAsset.addField(newf);
        }
    }

    protected <T extends IField> T getFieldForXpathAndIndex(Map<String, T> iFieldsMap, String xpath, List<Integer> indices) {
        return (T)((IField)iFieldsMap.get(xpath + indices));
    }

    @Override
    public Document get(IIdentifier id, String revision) throws MetadataException, SearchException, TranslationException {
        this.logger.debug((Object)"In get(id, revision)");
        TTVId assetId = id.getAssetTTVId();
        return this.getRevision(assetId, revision);
    }

    protected Document getRevision(TTVId ttvId, String revision) throws SearchException, TranslationException {
        Asset asset = this.getAssetTree(ttvId, revision);
        return this.convertAssetToXMLDocument(asset);
    }

    protected int parseThenGetInternalRevisionNumber(String revision) throws SearchException {
        try {
            return Asset.getInternalRevision(revision);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e);
            throw new SearchException("Revision: " + revision + " is not in the format of " + "ExternalRevision.InternalRevision");
        }
    }

    protected String parseThenGetExternalRevisionNumber(String revision) throws SearchException {
        try {
            return Asset.getExternalRevision(revision);
        }
        catch (RuntimeException e) {
            this.logger.error((Object)e);
            throw new SearchException("Revision: " + revision + " is not in the format of " + "ExternalRevision.InternalRevision");
        }
    }

    @Override
    public List<RootAssetRevision> getRevisions(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        Asset asset = id.getAsset();
        if (!(asset instanceof Group)) {
            throw new MetadataException("Asset identified by input id: " + id + " is not a top-level asset!");
        }
        asset = this.metadataManagerDAO.getAsset(asset.getTTVId());
        return ((Group)asset).getRevisions();
    }

    protected Asset findAsset(Asset searchCandidate, List<Asset> searchTargets) {
        SearchCriteria crit = this.prepareSearchPathById(searchCandidate.getFields());
        for (Asset searchTarget : searchTargets) {
            List<Field> fields = searchTarget.getFields();
            boolean assetFound = this.isSearchCriteriaPresent(crit, fields);
            if (!assetFound) continue;
            return searchTarget;
        }
        return null;
    }

    protected Asset getAssetTree(TTVId ttvId, String revision) throws SearchException {
        Asset asset;
        int internalRevisionNumber = 0;
        if (revision != null && (internalRevisionNumber = this.parseThenGetInternalRevisionNumber(revision)) <= 0) {
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        try {
            asset = this.metadataManagerDAO.getAsset(ttvId, internalRevisionNumber);
        }
        catch (InvalidRevisionException e) {
            this.logger.error((Object)e);
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        return asset;
    }

    @Override
    public Document rollBackToRevision(TTVId ttvId, String revision) throws MetadataException, SearchException, TranslationException, InvalidRevisionException {
        this.verifyVersionNumber(ttvId, revision);
        Asset oldAsset = this.getAssetTree(ttvId, revision);
        ArrayList<Asset> toBeMergedAssets = new ArrayList<Asset>();
        toBeMergedAssets.add(oldAsset);
        RootAssetRevision rootAssetRevision = new RootAssetRevision("test", "Rollback to revision " + revision, this.parseThenGetExternalRevisionNumber(revision));
        this.mergeSaveAssets(toBeMergedAssets, true, rootAssetRevision, true, false);
        return this.getRevision(ttvId, null);
    }

    private void verifyVersionNumber(TTVId ttvId, String revision) throws SearchException, InvalidRevisionException {
        Asset oldAsset = this.getAssetTree(ttvId, null);
        if (revision.equalsIgnoreCase(oldAsset.getVersion())) {
            throw new InvalidRevisionException("Can't rollback to latest version: " + revision + ", please try a different version.");
        }
    }

    @Override
    public List<Asset> save(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        return null;
    }

    @Override
    @Deprecated
    public Spec getSpecName(Document doc) {
        String name = doc.getDocumentElement().getNodeName();
        if (name.equals(this.rootElementName)) {
            return this.spec;
        }
        return null;
    }

    @Override
    public String getSpecAlias(Document doc) {
        String name = doc.getDocumentElement().getNodeName();
        if (name.equals(this.rootElementName)) {
            return this.alias;
        }
        return null;
    }

    protected <N extends IField, O extends IField> List<O> getToBeDeleted(Map<String, N> newFieldsMap, List<O> oldFields, String assetType) {
        if (oldFields == null) {
            return new ArrayList();
        }
        ArrayList<IField> toBeDeletedFields = new ArrayList<IField>();
        for (IField oldField : oldFields) {
            if (this.isXPathPartOfSpec(assetType, oldField.getTtvXPath())) {
                N newField = this.getFieldForXpathAndIndex(newFieldsMap, oldField.getTtvXPath(), oldField.getIndices());
                if (newField != null) continue;
                toBeDeletedFields.add(oldField);
                continue;
            }
            this.logger.warn((Object)("getToBeDeleted: Could not find " + oldField.getTtvXPath() + " in " + assetType + " TTV spec"));
        }
        return toBeDeletedFields;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        assetType = assetType.toLowerCase();
        Set<String> xpathSet = null;
        if (this.specSpecificTTVXpaths.containsKey(assetType)) {
            xpathSet = this.specSpecificTTVXpaths.get(assetType);
        }
        return xpathSet != null && xpathSet.contains(ttvXPath);
    }

    @Override
    @Transactional
    public List<Asset> createNewAssetWithoutSave(Document doc) throws MetadataException {
        return this.mergeAssetsWithoutSave(null, doc, false);
    }

    @Override
    @Transactional
    public List<Asset> mergeWithoutSave(Document doc) throws MetadataException {
        return this.mergeAssetsWithoutSave(null, doc, true);
    }

    @Override
    @Transactional
    public List<Asset> mergeWithoutSave(Long assetId, Document doc) throws MetadataException {
        Asset existingAsset = null;
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        try {
            existingAsset = this.getMetadataManagerDAO().getAsset(ttvId);
        }
        catch (SearchException e) {
            this.logger.error((Object)e);
            throw new MetadataException("Unable to find asset with id=" + ttvId.getId());
        }
        return this.mergeAssetsWithoutSave(existingAsset, doc, true);
    }

    private List<Asset> mergeAssetsWithoutSave(Asset assetToMerge, Document doc, boolean tryFindExisingAsset) throws MetadataException {
        ArrayList<Asset> returnAssets = new ArrayList<Asset>();
        List<Asset> assets = this.convertDocumentToAssets(doc);
        Iterator<Asset> assetIter = assets.iterator();
        Map<String, List<String>> cfs = this.getMetadataManagerDAO().getAllCustomFieldNames();
        while (assetIter.hasNext()) {
            Asset newAsset = assetIter.next();
            Asset existingAsset = null;
            if (assetToMerge != null) {
                existingAsset = assetToMerge;
            } else if (tryFindExisingAsset) {
                try {
                    existingAsset = this.extractId(newAsset).getAsset();
                }
                catch (SearchException e) {
                    this.logger.error((Object)e);
                }
            }
            AssetUtil.deleteEmptyFields(newAsset);
            Asset.setPaths(newAsset, null);
            AssetUtil.removeInvalidCustomFields(newAsset, cfs);
            if (existingAsset == null || existingAsset.getState() == AssetState.INACTIVE) {
                NextRevision nextRevision = new NextRevision();
                AssetUtil.copyFieldsToFieldRevisions(newAsset, nextRevision);
            } else {
                this.mergeRecursively(newAsset, existingAsset);
            }
            returnAssets.add(newAsset);
        }
        return returnAssets;
    }

    protected void mergeRecursively(Asset newAsset, Asset existingAsset) {
        String assetType = this.getAssetType(newAsset);
        newAsset.setTTVId(existingAsset.getTTVId());
        newAsset.setOriginalAssetID(existingAsset.getOriginalAssetID());
        newAsset.setOriginalRevisionNumber(existingAsset.getOriginalRevisionNumber());
        this.mergeFields(newAsset, existingAsset, assetType);
        for (Relation r : existingAsset.getRelations()) {
            Asset existingTargetAsset = r.getTargetAsset();
            String existingAssetType = this.getAssetType(existingTargetAsset);
            if (this.requireSpecSpecificMerging(existingAssetType)) {
                this.specSpecificMergingNoSave(newAsset, r, existingTargetAsset);
                continue;
            }
            Asset newTargetAsset = this.findAsset(existingTargetAsset, newAsset.getImmediateChildren());
            if (newTargetAsset == null) {
                if (this.isAssetTypePartOfSpec(existingAssetType)) continue;
                newAsset.addChild(this.copyAssetTree(existingTargetAsset));
                continue;
            }
            this.mergeRecursively(newTargetAsset, existingTargetAsset);
        }
    }

    protected Asset copyAssetTree(Asset asset) {
        Asset copy = null;
        if (asset.getClass().equals(Group.class)) {
            copy = new Group();
            ((Group)copy).setType(asset.getAssetType());
        } else if (asset.getClass().equals(Item.class)) {
            copy = new Item();
            ((Item)copy).setType(asset.getAssetType());
        } else if (asset.getClass().equals(File.class)) {
            copy = new File();
        }
        copy.setTTVId(asset.getTTVId());
        copy.setOriginalAssetID(asset.getOriginalAssetID());
        copy.setOriginalRevisionNumber(asset.getOriginalRevisionNumber());
        for (Field f : asset.getFields()) {
            copy.addField(new Field(f));
        }
        for (Relation r : asset.getRelations()) {
            Asset targetAsset = r.getTargetAsset();
            copy.addChild(this.copyAssetTree(targetAsset));
        }
        return copy;
    }

    protected void mergeFields(Asset newAsset, Asset existingAsset, String assetType) {
        List<Field> oldFields = existingAsset.getFields();
        for (Field f : oldFields) {
            Field newField = this.getFieldForXpathAndIndex(newAsset.getFieldsMap(), f.getTtvXPath(), f.getIndices());
            if (newField != null || this.isXPathPartOfSpec(assetType, f.getTtvXPath())) continue;
            newAsset.addField(new Field(f));
        }
    }

    @Override
    public Document convertAssetToXMLDocument(Asset asset) throws TranslationException {
        Document tree = new Binder().bind(asset);
        Document assetDoc = this.getFromTTV().translate(this.kludge(tree));
        return assetDoc;
    }

    @Override
    public String getSpecName() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public ExpList getSearchFieldsToValidatePersistedCopies(Asset asset) {
        SearchCriteria assetKey = this.getAssetSpecificationKey(asset);
        if (assetKey == null || assetKey.isEmptyCriteria()) {
            return null;
        }
        return new SearchFieldBuilder().getAssetSearchFields(assetKey, false);
    }

    protected SearchCriteria getAssetSpecificationKey(Asset asset) {
        IIdentifier identifier = this.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals(EMPTY_STRING_VALUE)) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    @Override
    public void associateTitleToSeries(Asset rootAsset, Long seriesDocumentId, Long seasonAssetId) throws MetadataException {
        ((Group)rootAsset).setSeriesDocumentId(seriesDocumentId);
        ((Group)rootAsset).setSeasonAssetId(seasonAssetId);
        this.getMetadataManagerDAO().saveAsset(rootAsset);
    }

    @Override
    public Map<String, Map<String, List<String>>> getAllIndexFields() throws MetadataException {
        return this.metadataManagerDAO.getAllIndexFields();
    }

    @Override
    public String createUniqueIndex(String specAlias, Collection<String> ttvPaths) {
        return this.metadataManagerDAO.createUniqueIndex(specAlias, ttvPaths);
    }

    @Override
    public void dropIndexes(Set<String> indexNames) {
        this.metadataManagerDAO.dropIndexes(indexNames);
    }
}

