/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.sql;

import com.tandbergtv.metadatamanager.sql.AbstractSQLBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class InsertBuilder
extends AbstractSQLBuilder {
    private String table = "";
    private List<String> columns = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();

    public InsertBuilder() {
    }

    public InsertBuilder(String table) {
        this.table = table;
    }

    public InsertBuilder table(String table) {
        this.table = table;
        return this;
    }

    public InsertBuilder column(String name) {
        this.columns.add(name);
        return this;
    }

    public InsertBuilder values(String value) {
        this.values.add(value);
        return this;
    }

    @Override
    public String build() {
        if (StringUtils.isEmpty((Object)this.table)) {
            throw new IllegalArgumentException("table cannot be empty.");
        }
        if (this.columns.isEmpty()) {
            throw new IllegalArgumentException("columns cannot be empty.");
        }
        if (!this.values.isEmpty() && this.columns.size() != this.values.size()) {
            throw new IllegalArgumentException("must set values for corresponding columns.");
        }
        return this.toString();
    }

    public String toString() {
        StringBuilder sql = new StringBuilder("insert into ");
        sql.append(this.table);
        this.appendList(sql, this.columns, " (", ", ", ") ");
        if (this.values.isEmpty()) {
            this.values.addAll(Collections.nCopies(this.columns.size(), "?"));
        }
        this.appendList(sql, this.values, "values (", ", ", ") ");
        return sql.toString();
    }

    private void appendList(StringBuilder sql, List<String> list, String init, String sep, String last) {
        this.appendList(sql, list, init, sep);
        sql.append(last);
    }
}

