/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DBNameFinder {
    private HibernateTemplate template;
    private static DBNameFinder _instance;

    public DBNameFinder(HibernateTemplate template) {
        this.template = template;
        _instance = this;
    }

    public static synchronized DBNameFinder getInstance() {
        return _instance;
    }

    public String getTableName(Class<?> clazz) {
        ClassMetadata metadata = this.template.getSessionFactory().getClassMetadata(clazz);
        if (metadata instanceof AbstractEntityPersister) {
            AbstractEntityPersister persister = (AbstractEntityPersister)metadata;
            return persister.getTableName();
        }
        return null;
    }

    public String getColumnName(Class<?> clazz, String property) {
        ClassMetadata metadata = this.template.getSessionFactory().getClassMetadata(clazz);
        if (metadata instanceof AbstractEntityPersister) {
            AbstractEntityPersister persister = (AbstractEntityPersister)metadata;
            return persister.getPropertyColumnNames(property)[0];
        }
        return null;
    }
}

