/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.exception.MappingFileParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MappingFileParser {
    private static final String MAPPING_DELIMITER = ",";
    private static ConcurrentHashMap<String, Map<String, String>> resourceFieldMap = new ConcurrentHashMap();

    private MappingFileParser() {
    }

    public static ConcurrentHashMap<String, String> readFieldMapping(String mappingResource) {
        ConcurrentHashMap<String, String> mappings = new ConcurrentHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(mappingResource)));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static ConcurrentHashMap<String, String> readFieldExtMapping(String mappingResource) {
        ConcurrentHashMap<String, String> mappings = new ConcurrentHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(mappingResource)));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputExtStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static Map<String, String> readFieldMapping(InputStream mappingResourceStream) {
        ConcurrentHashMap<String, String> mappings = new ConcurrentHashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceStream));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static Map<String, String> readFieldExtMapping(InputStream mappingResourceStream) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceStream));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputExtStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static Map<String, Boolean> readFieldMappingWithBooleanValue(InputStream mappingResourceStream) {
        HashMap<String, Boolean> mappings = new HashMap<String, Boolean>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceStream));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputStreamWithBooleanValue(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static Map<String, String> readFieldMapping(URL mappingResourceUrl) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(mappingResourceUrl.openConnection().getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    public static Map<String, String> readFieldMapping(File mappingResourceFile) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        try (FileInputStream inputStream = new FileInputStream(mappingResourceFile);
             BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                MappingFileParser.readInputStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    private static void readInputStream(Map<String, String> mappings, String line) {
        if (line.startsWith("#") || line.indexOf(MAPPING_DELIMITER) == -1) {
            return;
        }
        String[] fieldMapping = line.split(MAPPING_DELIMITER);
        mappings.put(fieldMapping[0].trim(), fieldMapping[1].trim());
    }

    private static void readInputExtStream(Map<String, String> mappings, String line) {
        if (line.startsWith("#") || line.indexOf(MAPPING_DELIMITER) == -1) {
            return;
        }
        String[] fieldMapping = line.split(MAPPING_DELIMITER);
        if (fieldMapping.length > 2) {
            mappings.put(fieldMapping[0].trim(), fieldMapping[2].trim());
        }
    }

    private static void readInputStreamWithBooleanValue(Map<String, Boolean> mappings, String line) {
        if (line.startsWith("#") || line.indexOf(MAPPING_DELIMITER) == -1) {
            return;
        }
        String[] fieldMapping = line.split(MAPPING_DELIMITER);
        mappings.put(fieldMapping[0].trim(), Boolean.valueOf(fieldMapping[1].trim()));
    }

    public static String getMapping(String mappingResource, String field) {
        Map<String, String> fields = resourceFieldMap.get(mappingResource);
        if (fields == null) {
            fields = MappingFileParser.readFieldMapping(mappingResource);
            resourceFieldMap.put(mappingResource, fields);
        }
        return fields.containsKey(field) ? fields.get(field) : "";
    }

    public static String getMapping(URL mappingResourceUrl, String field) {
        Map<String, String> fields = resourceFieldMap.get(mappingResourceUrl.getPath());
        if (fields == null) {
            fields = MappingFileParser.readFieldMapping(mappingResourceUrl);
            resourceFieldMap.put(mappingResourceUrl.getPath(), fields);
        }
        return fields.containsKey(field) ? fields.get(field) : "";
    }
}

