/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util.binder;

import com.tandbergtv.metadatamanager.model.Field;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ECMFFieldJsonBinder {
    public String convert(List<Field> fields) {
        JSONObject objRoot = new JSONObject();
        JSONObject objFields = new JSONObject();
        try {
            objRoot.put("Fields", (Object)objFields);
            for (Field fld : fields) {
                this.addToJsonTree(fld, objFields);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return objRoot.toString();
    }

    private void addToJsonTree(Field fld, JSONObject fldsObject) throws JSONException {
        String xpath = fld.getTtvXPath();
        String attribute = "";
        if (xpath.indexOf("/@") > -1) {
            attribute = xpath.replaceFirst(".*/@", "");
            xpath = xpath.replaceFirst("/@.*", "");
        }
        String[] xpathSplit = xpath.split("/");
        List<Integer> indices = fld.getIndices();
        String value = fld.getValue();
        JSONObject parent = fldsObject;
        boolean isCustomField = false;
        String xpathChild = null;
        for (int i = 1; i < indices.size(); ++i) {
            JSONObject node = null;
            xpathChild = xpathSplit[i + 1];
            int index = indices.get(i);
            if (xpathChild.contains("CustomField[@name=")) {
                String cfName = this.extractCustomFieldName(xpathChild);
                isCustomField = true;
            } else {
                Iterator keys = parent.keys();
                int currentIndex = 0;
                while (keys.hasNext()) {
                    String fldNodeName = (String)keys.next();
                    Object child = parent.get(fldNodeName);
                    if (!(child instanceof JSONObject) || !xpathChild.equals(fldNodeName) || ++currentIndex != index) continue;
                    node = (JSONObject)child;
                    break;
                }
                if (i == indices.size() - 1) break;
                while (currentIndex < index) {
                    node = new JSONObject();
                    parent.put(xpathChild, (Object)node);
                    ++currentIndex;
                }
            }
            if (node == null) {
                throw new RuntimeException("Failed to create new child node for field: " + fld);
            }
            parent = node;
        }
        if (!attribute.equals("")) {
            if (!isCustomField) {
                parent.put(attribute, (Object)value);
            }
        } else {
            parent.put(xpathChild, (Object)value);
        }
    }

    private String extractCustomFieldName(String xpathChild) {
        String cfName = "";
        String[] o = xpathChild.split("=");
        if (o.length == 2) {
            cfName = o[1];
            cfName = cfName.replaceAll("\\]", "");
        }
        return cfName;
    }
}

