/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.validation.Schematron;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.validation.Schematron.Constants;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SchematronValidator
implements IValidator {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private String name;
    private File convertedRules;
    private String CONVERTED_RULES_XSL = "convertedRules.xsl";
    private static String SCHEMATRON_DSDL_INCLUDE_XSL = "iso_dsdl_include.xsl";
    private static String SCHEMATRON_EXPAND_XSL = "iso_abstract_expand.xsl";
    private static String SCHEMATRON_CONVERSION_XSL = "iso_svrl.xsl";
    private static String SVRL_URI = "http://purl.oclc.org/dsdl/svrl";
    private static String REPORT = "successful-report";
    private static String LOCATION_ATTR = "location";
    private static String FAILED_ASSERT_TEXT = "text";
    private static String ATTR_XPATH = "/@iso:schema";
    private static String REPLACE_ATTR_XPATH = "";
    private static String TEMP_FILE_DELIMITER = "_";
    private ClassLoader classLoader;

    public SchematronValidator(String name, String rulesResource) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(rulesResource);
        this.init(name, is);
    }

    public SchematronValidator(String name, InputStream is) {
        this.init(name, is);
    }

    public SchematronValidator(String name, InputStream is, ClassLoader loader) {
        this.classLoader = loader;
        this.init(name, is);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void init(String name, InputStream is) {
        Document rulesDoc;
        this.name = name;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            rulesDoc = builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Document temp1 = this.transform(this.classLoader.getResourceAsStream(SCHEMATRON_DSDL_INCLUDE_XSL), rulesDoc);
        Document temp2 = this.transform(this.classLoader.getResourceAsStream(SCHEMATRON_EXPAND_XSL), temp1);
        Document temp3 = this.transform(this.classLoader.getResourceAsStream(SCHEMATRON_CONVERSION_XSL), temp2);
        try {
            this.convertedRules = File.createTempFile(name + TEMP_FILE_DELIMITER, this.CONVERTED_RULES_XSL);
            this.cleanup(this.convertedRules.getParent());
            this.save(temp3, this.convertedRules);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanup(String path) {
        String[] files;
        File dir = new File(path);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(SchematronValidator.this.getName() + TEMP_FILE_DELIMITER);
            }
        };
        for (String filename : files = dir.list(filter)) {
            File f = new File(path, filename);
            f.delete();
            this.logger.debug((Object)("Deleted previously created file: " + path + filename));
        }
    }

    private Document transform(InputStream stream, Document input) {
        TransformerFactory tf = XmlUtil.createTransformerFactory(this.classLoader);
        if (this.classLoader == null) {
            tf.setURIResolver(new ResourceResolver());
        } else {
            tf.setURIResolver(new ResourceResolver(this.classLoader));
        }
        Transformer transformer = null;
        try {
            transformer = tf.newTransformer(new StreamSource(stream));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document docOut = builder.newDocument();
            DOMResult result = new DOMResult(docOut);
            transformer.transform(new DOMSource(input), result);
            return docOut;
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ValidationError> validate(Document doc) {
        try (FileInputStream stream = new FileInputStream(this.convertedRules);){
            Document report = this.transform(stream, doc);
            List<ValidationError> list = this.parse(report);
            return list;
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private List<ValidationError> parse(Document reportDoc) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        NodeList asserts = reportDoc.getElementsByTagNameNS(SVRL_URI, REPORT);
        for (int i = 0; i < asserts.getLength(); ++i) {
            ValidationError error;
            Element node = (Element)asserts.item(i);
            String location = node.getAttribute(LOCATION_ATTR);
            if (location.contains(ATTR_XPATH)) {
                location = location.replace(ATTR_XPATH, REPLACE_ATTR_XPATH);
            }
            String text = node.getElementsByTagNameNS(SVRL_URI, FAILED_ASSERT_TEXT).item(0).getTextContent();
            String[] errorText = text.split(Constants.ERROR_TEXT_DELIMITER);
            String errorCode = new String();
            ArrayList<String> errorFields = new ArrayList<String>();
            ArrayList<String> errorInfo = new ArrayList<String>();
            if (errorText.length > 0) {
                String[] errorFieldList;
                errorCode = errorText[Constants.ERROR_CODE_POSITION];
                for (String field : errorFieldList = errorText[Constants.ERROR_FIELDS_POSITION].split(Constants.INFO_DELIMITER)) {
                    errorFields.add(field.trim());
                }
                if (errorText.length == Constants.ERROR_MAX_ITEM_COUNT) {
                    String[] errorInfoList;
                    for (String field : errorInfoList = errorText[Constants.ERROR_INFO_POSITION].split(Constants.INFO_DELIMITER)) {
                        errorInfo.add(field.trim());
                    }
                }
            }
            if (this.isDuplicate(errors, error = new ValidationError(errorCode, location, errorFields, errorInfo))) continue;
            errors.add(error);
        }
        return errors;
    }

    private boolean isDuplicate(List<ValidationError> errors, ValidationError error) {
        for (ValidationError e : errors) {
            if (!e.getErrorLocation().equalsIgnoreCase(error.getErrorLocation()) || !e.getErrorCode().equalsIgnoreCase(error.getErrorCode()) || e.getErrorFields().size() != error.getErrorFields().size()) continue;
            for (String fieldName : e.getErrorFields()) {
                if (error.getErrorFields().contains(fieldName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void save(Document doc, File outFile) {
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer(new FileOutputStream(outFile, false), format);
            serializer.serialize(doc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

