/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractConfigBuilder<C> {
    protected static final String PROP_INITIAL_WAIT_SECONDS = "hazelcast.initial.wait.seconds";
    protected static final String DEFAULT_DNS_NAME = "app-nodes.service";
    protected static final String DEFAULT_CONTENT_SERVER_DNS_NAME = "ct-nodes.service";
    protected static final String TCPIP = "tcpip";
    protected String configFile;
    protected String portKey = "host.port";
    protected String discoveryTypeKey = "discovery.type";
    protected String multicastIpKey = "multicast.ip";
    protected String multicastPortKey = "multicast.port";
    protected String unicastHostsKey = "tcpip.hosts";
    protected String hostKey = "host.ip";
    protected String interfaceKey = "host.interface";
    protected String clusterNameKey = "cluster.name";
    protected String clusterPasswordKey = "cluster.password";
    protected String initialWaitKey = "initial.wait";
    protected String autoIncrementKey = "port.auto.increment";
    protected int defaultPort = -1;
    protected boolean isPortAutoIncrement = true;
    protected static Map<String, Map<String, String>> registerDefaultComponentProps = new LinkedHashMap<String, Map<String, String>>();

    public AbstractConfigBuilder(String configFile) {
        this.configFile = configFile;
    }

    public AbstractConfigBuilder<C> portKey(String portKey) {
        this.portKey = portKey;
        return this;
    }

    public AbstractConfigBuilder<C> discoveryTypeKey(String discoveryTypeKey) {
        this.discoveryTypeKey = discoveryTypeKey;
        return this;
    }

    public AbstractConfigBuilder<C> multicastIpKey(String multicastIpKey) {
        this.multicastIpKey = multicastIpKey;
        return this;
    }

    public AbstractConfigBuilder<C> multicastPortKey(String multicastPortKey) {
        this.multicastPortKey = multicastPortKey;
        return this;
    }

    public AbstractConfigBuilder<C> unicastHostsKey(String unicastHostsKey) {
        this.unicastHostsKey = unicastHostsKey;
        return this;
    }

    public AbstractConfigBuilder<C> hostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public AbstractConfigBuilder<C> interfaceKey(String interfaceKey) {
        this.interfaceKey = interfaceKey;
        return this;
    }

    public AbstractConfigBuilder<C> clusterNameKey(String clusterNameKey) {
        this.clusterNameKey = clusterNameKey;
        return this;
    }

    public AbstractConfigBuilder<C> clusterPasswordKey(String clusterPasswordKey) {
        this.clusterPasswordKey = clusterPasswordKey;
        return this;
    }

    public AbstractConfigBuilder<C> initialWaitKey(String initialWaitKey) {
        this.initialWaitKey = initialWaitKey;
        return this;
    }

    public AbstractConfigBuilder<C> autoIncrementKey(String autoIncrementKey) {
        this.autoIncrementKey = autoIncrementKey;
        return this;
    }

    public AbstractConfigBuilder<C> defaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    public AbstractConfigBuilder<C> isPortAutoIncrement(boolean isPortAutoIncrement) {
        this.isPortAutoIncrement = isPortAutoIncrement;
        return this;
    }

    protected InetAddress getAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }

    protected InetAddress getIPv4AddressByInterface(String iname) {
        NetworkInterface netInterface = null;
        try {
            netInterface = NetworkInterface.getByName(iname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (netInterface == null) {
            throw new RuntimeException("Invalid network interface '" + iname + "'");
        }
        Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!(address instanceof Inet4Address)) continue;
            return address;
        }
        throw new RuntimeException("Could not find IPv4 address for network interface " + iname);
    }

    protected Map<String, String> createDefaultProps(String ... values) {
        if (values.length < 5) {
            throw new IllegalArgumentException("we need at 5 parmeters for hazelcast setting");
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put(this.discoveryTypeKey, values[0]);
        props.put(this.unicastHostsKey, values[1]);
        props.put(this.clusterNameKey, values[2]);
        props.put(this.clusterPasswordKey, values[3]);
        props.put(this.portKey, values[4]);
        if (values.length > 5) {
            props.put(this.autoIncrementKey, values[5]);
        }
        return props;
    }

    protected AbstractConfigBuilder<C> registerDefaultProps(String configKey, Map<String, String> props) {
        registerDefaultComponentProps.put(configKey, props);
        return this;
    }

    public AbstractConfigBuilder<C> registerDefaultProps(Map<String, String> props) {
        registerDefaultComponentProps.put(this.configFile, props);
        return this;
    }

    public AbstractConfigBuilder<C> registerDefaultProps(String discoveryType, String unicastHosts, String clusterName, String clusterPass, String port, String autoIncrement) {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put(this.discoveryTypeKey, discoveryType);
        props.put(this.unicastHostsKey, unicastHosts);
        props.put(this.clusterNameKey, clusterName);
        props.put(this.clusterPasswordKey, clusterPass);
        props.put(this.portKey, port);
        props.put(this.autoIncrementKey, autoIncrement);
        this.registerDefaultProps(props);
        return this;
    }

    public abstract C build() throws IOException;

    protected void loadDefaultProperties(String path, Properties props) {
        Map<String, String> propsMap = registerDefaultComponentProps.get(path);
        if (propsMap == null) {
            throw new IllegalArgumentException("There are no default properties for " + path);
        }
        props.putAll(propsMap);
    }
}

