/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.config;

import com.ericsson.cms.neptune.cluster.config.AbstractConfigBuilder;
import com.ericsson.cms.neptune.cluster.util.AdvancedProperties;
import com.hazelcast.config.ClasspathXmlConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.config.TcpIpConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ConfigBuilder
extends AbstractConfigBuilder<Config> {
    private static final Logger LOGGER = Logger.getLogger(ConfigBuilder.class);
    public static final String PRODUCT_DIR = "/opt/tandbergtv/cms/conf";
    public static final String CLUSTER_NEPTUNE = "/opt/tandbergtv/cms/conf/neptune/cluster.properties";
    public static final String CLUSTER_NEPTUNE_OAUTH = "/opt/tandbergtv/cms/conf/neptune/oauthCluster.properties";
    public static final String CLUSTER_WORKFLOW = "/opt/tandbergtv/cms/conf/workflow/cluster.properties";
    public static final String CLUSTER_WATCHFOLDER = "/opt/tandbergtv/cms/conf/watchfolder/cluster.properties";
    public static final String CLUSTER_FILEUPLOADER = "/opt/tandbergtv/cms/conf/fileuploader/cluster.properties";
    public static final String CLUSTER_EPG = "/opt/tandbergtv/cms/conf/epgmgmt/cluster.properties";
    private String xmlConfigPathKey = "xml.config.path";

    private ConfigBuilder() {
        super(null);
    }

    public ConfigBuilder(String configFile) {
        super(configFile);
    }

    public ConfigBuilder(String configFile, Map<String, String> defaultProps) {
        super(configFile);
        this.registerDefaultProps(defaultProps);
    }

    public AbstractConfigBuilder<Config> xmlConfigPathKey(String xmlConfigPathKey) {
        this.xmlConfigPathKey = xmlConfigPathKey;
        return this;
    }

    private Config create(AdvancedProperties properties) throws IOException {
        String xmlPath = properties.getProperty(this.xmlConfigPathKey);
        if (xmlPath != null) {
            return new FileSystemXmlConfig(xmlPath);
        }
        ClasspathXmlConfig config = null;
        try {
            config = new ClasspathXmlConfig(ConfigBuilder.class.getClassLoader(), "com/ericsson/cms/neptune/cluster/config/hazelcast-datastructure.xml");
        }
        catch (Exception e) {
            LOGGER.warn((Object)("cannot read internal data structure configuration, use default, error: " + e));
            config = new Config();
        }
        this.configureClusterDiscovery((Config)config, properties);
        this.configurePort(properties, (Config)config);
        this.configureInterfaces((Config)config, properties);
        this.configureClusterName((Config)config, properties);
        this.configureInitialWait((Config)config, properties);
        return config;
    }

    private void configurePort(AdvancedProperties properties, Config config) {
        String autoIncrementStr;
        int port = properties.getInt(this.portKey, this.defaultPort);
        if (port > -1) {
            config.getNetworkConfig().setPort(port);
        }
        if (StringUtils.isNotBlank((String)(autoIncrementStr = properties.getProperty(this.autoIncrementKey)))) {
            this.isPortAutoIncrement = Boolean.parseBoolean(autoIncrementStr);
        }
        config.getNetworkConfig().setPortAutoIncrement(this.isPortAutoIncrement);
    }

    private void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(this.initialWaitKey);
        if (StringUtils.isNotBlank((String)wait)) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(this.clusterNameKey);
        if (name != null) {
            LOGGER.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(this.clusterPasswordKey)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private void configureInterfaces(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(this.hostKey);
        String netInterface = properties.getProperty(this.interfaceKey);
        if (!StringUtils.isBlank((String)host)) {
            StringTokenizer stringTokenizer = new StringTokenizer(host, ",;");
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken().trim();
                if (!StringUtils.isNotBlank((String)token)) continue;
                config.getNetworkConfig().getInterfaces().addInterface(token);
                LOGGER.debug((Object)("Added interface " + host));
            }
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        } else if (!StringUtils.isBlank((String)netInterface)) {
            String ip = this.getIPv4AddressByInterface(netInterface).getHostAddress();
            config.getNetworkConfig().getInterfaces().addInterface(ip);
            LOGGER.debug((Object)("Added interface " + host));
            config.getNetworkConfig().getInterfaces().setEnabled(true);
        }
    }

    private void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(this.discoveryTypeKey);
        LOGGER.debug((Object)("Hazelcast discovery type: " + discoveryType));
        if ("MULTICAST".equalsIgnoreCase(discoveryType)) {
            this.configureMulticastDiscovery(config, properties);
        } else {
            this.configureTcpIpDiscovery(config, properties);
        }
    }

    private void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        LOGGER.debug((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(this.multicastIpKey);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            LOGGER.debug((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(this.multicastPortKey)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            LOGGER.debug((Object)("Cluster multicast port: " + port));
        }
    }

    private void configureTcpIpDiscovery(Config config, Properties properties) {
        LOGGER.debug((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(this.unicastHostsKey);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    InetAddress[] ias;
                    if (!StringUtils.isNotBlank((String)host)) continue;
                    LOGGER.debug((Object)("Adding host: " + host));
                    for (InetAddress iAddr : ias = InetAddress.getAllByName(host)) {
                        String addr = iAddr.getHostAddress();
                        LOGGER.debug((Object)("Adding " + host + " address: " + addr));
                        tcpip.addMember(addr);
                    }
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException("Unknown host: " + host);
                }
            }
        }
    }

    @Override
    public Config build() throws IOException {
        AdvancedProperties props = new AdvancedProperties();
        if (!props.loadFromFile(this.configFile)) {
            LOGGER.info((Object)("Could not load settings from file '" + this.configFile + "'. Will try loading from classpath."));
            if (!props.loadFromClassPath(this.configFile)) {
                LOGGER.info((Object)("Could not load settings from class path '" + this.configFile + "'. Will use default settings."));
                this.loadDefaultProperties(this.configFile, props);
            }
        }
        return this.create(props);
    }

    static {
        ConfigBuilder config = new ConfigBuilder();
        config.registerDefaultProps(CLUSTER_NEPTUNE, config.createDefaultProps("tcpip", "app-nodes.service", "neptune", "neptune", "5950", "false"));
        config.registerDefaultProps(CLUSTER_NEPTUNE_OAUTH, config.createDefaultProps("tcpip", "app-nodes.service", "oauth_neptune", "neptune", "5951", "false"));
        config.registerDefaultProps(CLUSTER_WORKFLOW, config.createDefaultProps("tcpip", "app-nodes.service", "workflow", "workflow", "5712", "false"));
        config.registerDefaultProps(CLUSTER_WATCHFOLDER, config.createDefaultProps("tcpip", "ct-nodes.service", "watchfolder", "watchfolder", "5952", "false"));
        config.registerDefaultProps(CLUSTER_FILEUPLOADER, config.createDefaultProps("tcpip", "ct-nodes.service", "fileuploader", "fileuploader", "5953", "false"));
        config.registerDefaultProps(CLUSTER_EPG, config.createDefaultProps("tcpip", "app-nodes.service", "epg", "epg", "6709", "false"));
    }
}

