/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.service.impl;

import com.ericsson.cms.neptune.cluster.service.IClusterClientService;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.Validate;

public abstract class AbstractClusterService
implements IClusterClientService {
    protected String configFile;
    protected HazelcastInstance instance;

    public AbstractClusterService() {
    }

    public AbstractClusterService(String configFile) {
        Validate.notEmpty((String)configFile, (String)"Configuration file path could not be blank or null");
        this.configFile = configFile;
    }

    @Override
    public HazelcastInstance getInstance() {
        return this.instance;
    }

    @Override
    public Member getMaster() {
        return (Member)this.instance.getCluster().getMembers().iterator().next();
    }

    @Override
    public Member getMemberByAddress(InetSocketAddress address) {
        for (Member member : this.instance.getCluster().getMembers()) {
            if (!member.getSocketAddress().equals(address)) continue;
            return member;
        }
        return null;
    }

    @Override
    public Partition getPartition(Object key) {
        return this.instance.getPartitionService().getPartition(key);
    }

    @Override
    public int getPartitionId(Object key) {
        return this.getPartition(key).getPartitionId();
    }

    @Override
    public String getMemberName(Object key) {
        return this.getPartition(key).getOwner().toString();
    }

    @Override
    public Set<Member> members() {
        HashSet<Member> members = new HashSet<Member>(this.instance.getCluster().getMembers());
        return members;
    }

    @Override
    public boolean isMember(InetSocketAddress address) {
        return this.getMemberByAddress(address) != null;
    }

    @Override
    public boolean isMember(Member member) {
        return this.instance.getCluster().getMembers().contains(member);
    }

    @Override
    public long generateId(String type) {
        return this.instance.getIdGenerator(type).newId();
    }

    @Override
    @PostConstruct
    public void start() {
        this.instance = this.createInstance();
        Validate.notNull((Object)this.instance);
    }

    @Override
    @PreDestroy
    public void stop() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
    }

    @Override
    public String getServiceName() {
        return this.getClass().getName();
    }

    protected abstract HazelcastInstance createInstance();
}

