/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String threadNamePrefix;

    public NamedThreadFactory(String threadNamePrefix) {
        if (StringUtils.isBlank((String)threadNamePrefix)) {
            throw new IllegalArgumentException("threadNamePrefix can't be blank.");
        }
        this.threadNamePrefix = threadNamePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setName(this.threadNamePrefix + this.threadNumber.getAndIncrement());
        return t;
    }
}

