/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.cluster.util;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.util.NamedThreadFactory;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.executor.CompletableFutureTask;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RetrySubmitToMemberFutureTask<T>
extends AbstractCompletableFuture<T> {
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(RetrySubmitToMemberFutureTask.class);
    private static final ScheduledExecutorService RETRY_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(1, new NamedThreadFactory("RetrySubmitToMemberThread-"));
    private static final int[] RETRY_INTERVAL_LIST = new int[]{5, 5, 10, 10, 15, 15, 20};
    private int retryCount = 1;
    private int maxRetryCount = 10;

    public RetrySubmitToMemberFutureTask(Callable<T> callable, IExecutorService executorService, IClusterService clusterService, InetSocketAddress address) {
        super((Executor)RETRY_EXECUTOR_SERVICE, Logger.getLogger(CompletableFutureTask.class));
        RETRY_EXECUTOR_SERVICE.schedule(this.retrySubmitTaskToMember(callable, executorService, clusterService, address), (long)RETRY_INTERVAL_LIST[0], TimeUnit.SECONDS);
    }

    private Runnable retrySubmitTaskToMember(Callable<T> callable, IExecutorService executorService, IClusterService clusterService, InetSocketAddress address) {
        return () -> {
            Member target = clusterService.getMemberByAddress(address);
            if (target != null) {
                ICompletableFuture future = (ICompletableFuture)executorService.submitToMember(callable, target);
                future.andThen(new ExecutionCallback<T>(){

                    public void onResponse(T result) {
                        RetrySubmitToMemberFutureTask.this.setResult(result);
                    }

                    public void onFailure(Throwable throwable) {
                        RetrySubmitToMemberFutureTask.this.setResult(throwable);
                    }
                });
            } else if (this.retryCount < this.maxRetryCount) {
                int retryInterval = this.retryCount < RETRY_INTERVAL_LIST.length ? RETRY_INTERVAL_LIST[this.retryCount] : RETRY_INTERVAL_LIST[RETRY_INTERVAL_LIST.length - 1];
                ++this.retryCount;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)String.format("hazelcast target node %s is not available, submit the task %s again after %s second", address, callable, retryInterval));
                }
                RETRY_EXECUTOR_SERVICE.schedule(this.retrySubmitTaskToMember(callable, executorService, clusterService, address), (long)retryInterval, TimeUnit.SECONDS);
            } else {
                this.setResult(new IllegalStateException("Address unavailable: " + address));
            }
        };
    }
}

