/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.configuration.settings.client;

import com.ericsson.neptune.configuration.settings.client.ISettingsProvider;
import com.ericsson.neptune.configuration.settings.client.NeptuneSettingsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class CachedNeptuneSettingProvider
implements ISettingsProvider {
    private static final Logger LOGGER = Logger.getLogger(CachedNeptuneSettingProvider.class);
    private static final ConcurrentMap<String, CacheValue> CACHE = Maps.newConcurrentMap();
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final long EXPIRE_FOR_RETRIEVE = 300000L;
    private long expireTimeMillis = 300000L;
    private NeptuneSettingsProvider target = new NeptuneSettingsProvider();

    @Override
    public Map<String, String> getProperties(String path) {
        CacheValue cacheValue = (CacheValue)CACHE.get(path);
        if (cacheValue == null) {
            Map<String, String> settingValue = this.target.getProperties(path);
            LOGGER.debug((Object)("Cache missed, fetch the '" + path + "' setting" + settingValue + " from neptune server."));
            if (settingValue.isEmpty()) {
                return settingValue;
            }
            cacheValue = new CacheValue(System.currentTimeMillis(), settingValue);
            CACHE.put(path, cacheValue);
        } else {
            boolean expire;
            LOGGER.debug((Object)("Cache hit, fetch the '" + path + "' setting" + cacheValue.settingMap + " from local cache."));
            boolean bl = expire = System.currentTimeMillis() - cacheValue.lastRetrieveTimeMillis > this.expireTimeMillis;
            if (expire) {
                Map<String, String> settingValue = this.target.getProperties(path);
                LOGGER.debug((Object)("Cache expired, fetch the '" + path + "' setting" + settingValue + " neptune server."));
                if (!settingValue.isEmpty()) {
                    cacheValue = new CacheValue(System.currentTimeMillis(), settingValue);
                    CACHE.put(path, cacheValue);
                }
            }
        }
        return cacheValue.settingMap;
    }

    @Override
    public String getPropertiesAsJSON(String path) {
        Map<String, String> settingMap = this.getProperties(path);
        try {
            return MAPPER.writeValueAsString(settingMap);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    @Override
    public void saveSingleSetting(String path, String name, String value) throws Exception {
        this.target.saveSingleSetting(path, name, value);
    }

    @Override
    public void saveSettings(String path, Map<String, String> settings) throws Exception {
        this.target.saveSettings(path, settings);
    }

    public void setRetry(int retry) {
        this.target.setRetry(retry);
    }

    public void setInterval(int interval) {
        this.target.setInterval(interval);
    }

    public void setExpireTimeMillis(long expireTimeMillis) {
        this.expireTimeMillis = expireTimeMillis;
    }

    public void setTarget(NeptuneSettingsProvider target) {
        this.target = target;
    }

    private static class CacheValue {
        private long lastRetrieveTimeMillis;
        private Map<String, String> settingMap;

        public CacheValue(long lastRetrieveTimeMillis, Map<String, String> settingMap) {
            this.lastRetrieveTimeMillis = lastRetrieveTimeMillis;
            this.settingMap = settingMap;
        }
    }
}

