/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.configuration.settings.client;

import com.ericsson.neptune.configuration.settings.client.Credentials;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;

public class HttpRequest {
    private static final String CLIENT_KEY_STORE = "/var/lib/nobody/client_auth_keystore.jks";
    private static final String CMS_TRUST_STORE = "/var/lib/nobody/cms_truststore.jks";
    private static final String KEY_STORE_PASSWORD = "USh4ll!P4ss";
    private final URL url;
    private Credentials credentials;
    private String method;
    private int connectionTimeout = 30000;
    private int readTimeout = 30000;
    private String accept;
    private int status;
    private static final Logger logger = Logger.getLogger(HttpRequest.class);
    private static SSLSocketFactory sslSocketFactory;

    public HttpRequest(URL url) {
        this.url = (URL)Preconditions.checkNotNull((Object)url);
        this.method = "GET";
    }

    public HttpRequest method(String method) {
        this.method = (String)Preconditions.checkNotNull((Object)method);
        return this;
    }

    public HttpRequest accept(String type) {
        this.accept = (String)Preconditions.checkNotNull((Object)type);
        return this;
    }

    public HttpRequest credentials(Credentials credentials) {
        this.credentials = (Credentials)Preconditions.checkNotNull((Object)credentials);
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String read() throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = this.connect();
            this.status = connection.getResponseCode();
            logger.debug((Object)("Status code " + this.status));
            String string = this.read(connection);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void write(String string) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = this.connect();
            this.write(connection, string);
            this.status = connection.getResponseCode();
            logger.debug((Object)("Status code " + this.status));
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection connect() throws IOException {
        logger.debug((Object)("Making request to " + this.url));
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        if (connection instanceof HttpsURLConnection && this.credentials.isUseSSLCert() && sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)connection).setHostnameVerifier((host, session) -> host.endsWith("app"));
        } else if (this.credentials.getBasicAuthCreds() != null) {
            connection.setRequestProperty("Authorization", "Basic " + this.credentials.getBasicAuthCreds());
        } else if (this.credentials.getOAuth2Token() != null) {
            connection.setRequestProperty("Authorization", "Bearer " + this.credentials.getOAuth2Token());
        }
        connection.setRequestProperty("Accept", this.accept);
        connection.setRequestProperty("Content-Type", this.accept);
        connection.setDoOutput(true);
        connection.setRequestMethod(this.method);
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        return connection;
    }

    private String read(HttpURLConnection connection) throws IOException {
        String line;
        InputStream ris = connection.getInputStream();
        StringBuilder sb = new StringBuilder(200);
        BufferedReader br = new BufferedReader(new InputStreamReader(ris));
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(HttpURLConnection connection, String string) throws IOException {
        try (OutputStreamWriter w = new OutputStreamWriter(connection.getOutputStream());){
            w = new OutputStreamWriter(connection.getOutputStream());
            w.write(string);
            w.flush();
        }
        this.status = connection.getResponseCode();
        logger.debug((Object)("Status code " + this.status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(storeFormat);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(filePath);
            keyStore.load(fs, password.toCharArray());
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        return keyStore;
    }

    private static KeyManagerFactory createKeyManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = HttpRequest.loadKeyStore(storeFormat, filePath, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, password.toCharArray());
        return keyManagerFactory;
    }

    private static TrustManagerFactory createTrustManagerFactory(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = HttpRequest.loadKeyStore(storeFormat, filePath, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    private static SSLSocketFactory createCustomSocketFactory() throws Exception {
        KeyManagerFactory keyManagerFactory = HttpRequest.createKeyManagerFactory("JKS", CLIENT_KEY_STORE, KEY_STORE_PASSWORD);
        TrustManagerFactory trustManagerFactory = HttpRequest.createTrustManagerFactory("JKS", CMS_TRUST_STORE, KEY_STORE_PASSWORD);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        return context.getSocketFactory();
    }

    static {
        try {
            sslSocketFactory = HttpRequest.createCustomSocketFactory();
        }
        catch (Exception e) {
            logger.debug((Object)("Cannot create SSLSocketFactory with the reason: " + e.getMessage()));
        }
    }
}

