/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.es;

import com.ericsson.neptune.es.ESSettings;
import com.ericsson.neptune.es.ESUtil;
import com.ericsson.neptune.es.TransportClientThread;
import org.apache.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class CmsTransportClient {
    private static Logger LOGGER = Logger.getLogger(CmsTransportClient.class);
    private String propFileName;
    private volatile ESSettings esSettings;
    private TransportClient tc;
    private TransportClientThread thread;

    public CmsTransportClient() {
        this(null);
    }

    public CmsTransportClient(String propFileName) {
        this(propFileName, true);
    }

    public CmsTransportClient(String propFileName, boolean startUpdateThread) {
        this.propFileName = propFileName;
        this.esSettings = new ESSettings(propFileName);
        Settings settings = Settings.builder().put("cluster.name", this.esSettings.getClusterName()).build();
        this.tc = new PreBuiltTransportClient(settings, new Class[0]);
        LOGGER.info((Object)("Created TransportClient. Cluster name = '" + this.esSettings.getClusterName() + "'"));
        this.updateTransportAddresses();
        if (startUpdateThread) {
            this.thread = new TransportClientThread(this);
            this.thread.start();
        }
    }

    public TransportClient getTransportClient() {
        return this.tc;
    }

    public ESSettings getSettings() {
        return this.esSettings;
    }

    public void updateTransportAddresses() {
        ESUtil.updateTransportAddresses(this.tc, this.esSettings.getTransportPort());
    }

    public void updateSettings() {
        this.esSettings = new ESSettings(this.propFileName);
    }

    public void close() {
        if (this.thread != null) {
            this.thread.terminate();
            this.thread = null;
        }
        if (this.tc != null) {
            this.tc.close();
            this.tc = null;
        }
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        return this.tc.prepareSearch(indices);
    }

    public IndexRequestBuilder prepareIndex(String index, String type, String id) {
        return this.tc.prepareIndex(index, type, id);
    }

    public ActionFuture<UpdateResponse> update(UpdateRequest request) {
        return this.tc.update(request);
    }
}

