/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.es;

import java.util.Properties;

public class PropsUtil {
    private PropsUtil() {
    }

    public static String readString(Properties props, String name, String defaultValue) {
        if (props == null || name == null) {
            return defaultValue;
        }
        String str = props.getProperty(name);
        return PropsUtil.isEmpty(str) ? defaultValue : str;
    }

    public static int readPositiveInt(Properties props, String name, int defaultValue) {
        if (props == null || name == null) {
            return defaultValue;
        }
        String str = props.getProperty(name);
        if (PropsUtil.isEmpty(str)) {
            return defaultValue;
        }
        try {
            int i = Integer.parseInt(str);
            return i < 0 ? defaultValue : i;
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

