/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.service;

import com.ericsson.cms.neptune.rabbitmq.factory.IChannelFactory;
import com.ericsson.cms.neptune.rabbitmq.factory.ThreadLocalChannelFactory;
import com.ericsson.cms.neptune.rabbitmq.service.ChannelConfiguationPolicy;
import com.ericsson.cms.neptune.rabbitmq.service.IRabbitMQService;
import com.ericsson.cms.neptune.rabbitmq.service.WorkflowQueueDeclarer;
import com.ericsson.cms.neptune.rabbitmq.util.IMQConfiguration;
import com.ericsson.cms.neptune.rabbitmq.util.MQPropertyLoader;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;

public class RabbitMQService
implements IRabbitMQService {
    private static final Logger LOGGER = Logger.getLogger(RabbitMQService.class);
    private Lock startLock = new ReentrantLock();
    private IChannelFactory channelFactory;
    private Connection connection;
    private ChannelConfiguationPolicy channelConfiguationPolicy;
    private MQPropertyLoader mqPropertyLoader;
    private ConnectionFactory connectionFactory;
    private WorkflowQueueDeclarer workflowQueueDeclarer = new WorkflowQueueDeclarer();
    volatile boolean started = false;

    public RabbitMQService(MQPropertyLoader porpertyLoader) {
        this(porpertyLoader, new ConnectionFactory());
    }

    public RabbitMQService(MQPropertyLoader porpertyLoader, ConnectionFactory connectionFactory) {
        this.mqPropertyLoader = porpertyLoader;
        this.connectionFactory = connectionFactory;
        this.initConnectionFactory();
    }

    @Override
    @PostConstruct
    public void start() {
        if (this.started) {
            return;
        }
        List<Address> addresses = null;
        try {
            addresses = this.mqPropertyLoader.getNodeAddresses();
        }
        catch (UnknownHostException ue) {
            String errorMessage = "Failed to get node addresses for RabbitMQ Service";
            LOGGER.error((Object)errorMessage, (Throwable)ue);
            throw new IllegalStateException(errorMessage, ue);
        }
        try {
            this.connection = this.connectionFactory.newConnection(addresses);
            this.bindQueueDeclarersForConnection();
            this.channelFactory = new ThreadLocalChannelFactory(this.connection, this.channelConfiguationPolicy);
            this.addShutdownListener();
            this.addBlockedListener();
        }
        catch (IOException | TimeoutException ex) {
            throw new IllegalStateException("Cannot connect to  RabbitMQ service", ex);
        }
        this.started = true;
    }

    private void bindQueueDeclarersForConnection() {
        try {
            this.workflowQueueDeclarer.declare(this.connection);
        }
        catch (Exception e) {
            String errorMessage = "Cannot bind MQ declarer for current connection";
            LOGGER.warn((Object)errorMessage, (Throwable)e);
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExchangBinding(List<String> allComponents, List<String> byPassComponents) {
        Channel channel = this.getChannel(false);
        try {
            this.workflowQueueDeclarer.updateExchangeBinding(channel, allComponents, byPassComponents);
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create binding for bypass message", (Throwable)e);
        }
        finally {
            try {
                this.releaseChannel(channel);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Failed to create binding for bypass message", (Throwable)e);
            }
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.info((Object)("Cannot close RabbitMQ connection :" + e.getMessage()));
            }
        }
        this.started = false;
        this.connection = null;
        this.channelFactory = null;
    }

    @Override
    public void recoverConnection() {
        try {
            this.startLock.lock();
            LOGGER.debug((Object)"Got lock to resetup connection:");
            this.cleanCurrentThreadOwnedChannel();
            if (this.isAliveConnection()) {
                LOGGER.debug((Object)"The connection has gone back normal now, skip the reset up");
                return;
            }
            this.stop();
            this.start();
            this.validateCurrentThreadOwnedChannel();
            LOGGER.info((Object)"Reconnected to RabbitMQ, ready to work");
        }
        finally {
            this.startLock.unlock();
        }
    }

    private void validateCurrentThreadOwnedChannel() {
        if (!this.getChannel().isOpen()) {
            this.started = false;
            throw new IllegalStateException("Failed to setup channel to RabbitMQ");
        }
    }

    private void cleanCurrentThreadOwnedChannel() {
        try {
            Channel channel;
            Channel channel2 = channel = this.channelFactory != null ? this.channelFactory.getChannel() : null;
            if (channel != null) {
                this.releaseChannel(channel);
            }
        }
        catch (ShutdownSignalException e) {
            LOGGER.debug((Object)"Channel is closed", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Faled to close current thread owned channel", (Throwable)e);
        }
    }

    private boolean isAliveConnection() {
        try {
            if (this.connection != null && this.connection.isOpen()) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)"got error when check the status of connection. Illegal Connection status. ", (Throwable)e);
        }
        return false;
    }

    public void initConnectionFactory() {
        try {
            this.connectionFactory.setUsername(this.mqPropertyLoader.getUserName());
            this.connectionFactory.setPassword(this.mqPropertyLoader.getPassword());
            this.connectionFactory.setConnectionTimeout(this.mqPropertyLoader.getConnectionTimeOut());
            this.connectionFactory.setAutomaticRecoveryEnabled(false);
            this.connectionFactory.setTopologyRecoveryEnabled(this.mqPropertyLoader.isTopologyRecoveyEnabled());
            if (this.mqPropertyLoader.isSSLEnabled()) {
                this.connectionFactory.useSslProtocol(this.mqPropertyLoader.createSSLContext());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("ConnectionFactory initialize failed", e);
        }
    }

    private void addShutdownListener() {
        this.connection.addShutdownListener(new ShutdownListener(){
            Connection conn;
            {
                this.conn = RabbitMQService.this.connection;
            }

            public void shutdownCompleted(ShutdownSignalException cause) {
                LOGGER.info((Object)("RabbitMQ Connection[" + this.conn + "] is shutdown, reason:" + cause.getReason()));
            }
        });
    }

    private void addBlockedListener() {
        this.connection.addBlockedListener(new BlockedListener(){

            public void handleBlocked(String reason) throws IOException {
                LOGGER.error((Object)("RabbitMQ Connection is blocked. The reason is " + reason));
            }

            public void handleUnblocked() throws IOException {
                LOGGER.warn((Object)"RabbitMQ Connection is unblocked..");
            }
        });
    }

    @Override
    public Channel getChannel() {
        return this.getChannel(true);
    }

    @Override
    public Channel getChannel(boolean threadSharedMode) {
        Channel channel = null;
        try {
            channel = this.channelFactory != null ? this.channelFactory.getChannel(threadSharedMode) : null;
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Fail to get Channel due to " + e.getMessage()), (Throwable)e);
        }
        if (channel == null || !channel.isOpen()) {
            throw new AlreadyClosedException(new ShutdownSignalException(false, false, null, null), (Throwable)new IllegalStateException("Cannot find channel, connection is closed."));
        }
        return channel;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void addChannelConfigurationPolicy(ChannelConfiguationPolicy policy) {
        this.channelConfiguationPolicy = policy;
    }

    @Override
    public IMQConfiguration getConfiguration() {
        return this.mqPropertyLoader;
    }

    @Override
    public boolean releaseChannel(Channel channel) throws IOException {
        try {
            if (this.channelFactory != null) {
                this.channelFactory.removeChannel(channel);
            }
            if (channel != null) {
                channel.close();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Errors while close current channel.", (Throwable)e);
        }
        return false;
    }
}

