/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.service;

import com.ericsson.cms.neptune.rabbitmq.workflow.IRabbitMQDeclarer;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class WorkflowQueueDeclarer
implements IRabbitMQDeclarer {
    private static final Logger LOGGER = Logger.getLogger(WorkflowQueueDeclarer.class);
    private String generalRoutingKey = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declare(Connection connection) throws IOException {
        Channel channel = connection.createChannel();
        try {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("alternate-exchange", ALTERNATIVE_EXCHANGE_NAME);
            try {
                channel.exchangeDeclare(ALTERNATIVE_EXCHANGE_NAME, BuiltinExchangeType.FANOUT);
                channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE, false, false, args);
            }
            catch (Exception e) {
                if (this.isCausedByExistedWrongTypeExchange(e)) {
                    LOGGER.info((Object)("found a wrong legacy exchange type, Re create the exchange:" + EXCHANGE_TYPE));
                    channel = connection.createChannel();
                    channel.exchangeDeleteNoWait(EXCHANGE_NAME, false);
                    channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE, false, false, args);
                }
                throw new IllegalStateException(e);
            }
            this.declareQueue(channel);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (TimeoutException e) {
                    LOGGER.warn((Object)"Fail to close channel", (Throwable)e);
                }
            }
        }
    }

    private void declareQueue(Channel channel) {
        try {
            Map<String, Integer> m = new HashMap<String, Integer>();
            m.put("x-max-priority", 79);
            m = Collections.unmodifiableMap(m);
            channel.queueDeclare(BYPASS_QUEUE_NAME, true, false, false, m);
            channel.queueDeclare(QUEUE_NAME, true, false, false, m);
            channel.queueBind(QUEUE_NAME, ALTERNATIVE_EXCHANGE_NAME, this.generalRoutingKey);
            channel.queueUnbind(QUEUE_NAME, EXCHANGE_NAME, this.generalRoutingKey);
            channel.queueUnbind(BYPASS_QUEUE_NAME, EXCHANGE_NAME, this.generalRoutingKey);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create binding for queue and exchange.", (Throwable)e);
        }
    }

    public void updateExchangeBinding(Channel channel, List<String> allComponents, List<String> byPassComponents) {
        try {
            this.declareQueue(channel);
            if (this.isNotEmpty(allComponents)) {
                for (String name : allComponents) {
                    channel.queueBind(QUEUE_NAME, EXCHANGE_NAME, name);
                    channel.queueUnbind(BYPASS_QUEUE_NAME, EXCHANGE_NAME, name);
                }
            }
            if (this.isNotEmpty(byPassComponents)) {
                for (String name : byPassComponents) {
                    channel.queueBind(BYPASS_QUEUE_NAME, EXCHANGE_NAME, name);
                    channel.queueUnbind(QUEUE_NAME, EXCHANGE_NAME, name);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create binding for component type", (Throwable)e);
        }
    }

    private boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private boolean isCausedByExistedWrongTypeExchange(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof ShutdownSignalException) {
            String reason = ((ShutdownSignalException)((Object)ShutdownSignalException.class.cast(e.getCause()))).toString();
            return reason.contains("inequivalent arg 'type' for exchange") || reason.contains("inequivalent arg 'alternate-exchange' for exchange");
        }
        return false;
    }
}

