/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SSLUtil {
    private static final String KEYSTORE_FILE = "/var/lib/nobody/client_auth_keystore.jks";
    private static final String TRUSTSTORE_FILE = "/var/lib/nobody/cms_truststore.jks";
    private static final String KEYSTORE_PASSWORD_FILE = "/var/lib/nobody/keystore.pass";
    private static final String TRUST_INSTANCE_SUN_X509 = "SunX509";
    private static final String SSL_INSTANCE_TLS = "TLSv1.2";
    private static final String STORE_FORMAT_JKS = "JKS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String storeFormat, String filePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(storeFormat);
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(filePath);
            keyStore.load(fs, password.toCharArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fs);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fs);
        return keyStore;
    }

    private static KeyManagerFactory createKeyManagerFactory(String filePath, String password) throws Exception {
        KeyStore keyStore = SSLUtil.loadKeyStore(STORE_FORMAT_JKS, filePath, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        keyManagerFactory.init(keyStore, password.toCharArray());
        return keyManagerFactory;
    }

    private static TrustManagerFactory createTrustManagerFactory(String filePath, String password) throws Exception {
        KeyStore keyStore = SSLUtil.loadKeyStore(STORE_FORMAT_JKS, filePath, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_INSTANCE_SUN_X509);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    private static String getDefaultKeystorePassword() throws IOException {
        return FileUtils.readFileToString((File)new File(KEYSTORE_PASSWORD_FILE)).trim();
    }

    public static SSLContext createContext(String keystore, String keystorePass, String truststore, String truststorePass) throws Exception {
        String defaultPass = null;
        KeyManagerFactory kmf = null;
        if (StringUtils.isBlank((String)keystore)) {
            defaultPass = SSLUtil.getDefaultKeystorePassword();
            kmf = SSLUtil.createKeyManagerFactory(KEYSTORE_FILE, defaultPass);
        } else {
            kmf = SSLUtil.createKeyManagerFactory(keystore, keystorePass);
        }
        TrustManagerFactory tmf = truststore == null ? SSLUtil.createTrustManagerFactory(TRUSTSTORE_FILE, defaultPass == null ? SSLUtil.getDefaultKeystorePassword() : defaultPass) : SSLUtil.createTrustManagerFactory(truststore, truststorePass);
        SSLContext context = SSLContext.getInstance(SSL_INSTANCE_TLS);
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return context;
    }
}

