/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.sender;

import com.ericsson.cms.neptune.rabbitmq.sender.IMessageSender;
import com.ericsson.cms.neptune.rabbitmq.sender.support.AsynCallback;
import com.ericsson.cms.neptune.rabbitmq.sender.support.ConfirmTimeoutException;
import com.ericsson.cms.neptune.rabbitmq.sender.support.MessageProperties;
import com.ericsson.cms.neptune.rabbitmq.sender.support.MessagePropertiesSetter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class MessageSender
implements IMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageSender.class);
    private static final int DEFAULT_WAIT_FOR_CONFIRM_MS = 30000;
    public static final String REDELIVERY_TAG = "redelivery";
    private RabbitTemplate rabbitTemplate;
    private int waitForConfirmMilli = 30000;

    public MessageSender() {
    }

    public MessageSender(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public MessageSender(RabbitTemplate rabbitTemplate, int waitForConfirmMilli) {
        this.rabbitTemplate = rabbitTemplate;
        this.waitForConfirmMilli = waitForConfirmMilli;
    }

    @Override
    public void sendWithNoConfirm(String routingKey, Object message) {
        this.sendWithNoConfirm(null, routingKey, message, null);
    }

    @Override
    public void sendWithNoConfirm(String exchange, String routingKey, Object message) {
        this.sendWithNoConfirm(exchange, routingKey, message, null);
    }

    @Override
    public void sendWithNoConfirm(String routingKey, Object message, MessagePropertiesSetter setter) {
        this.sendWithNoConfirm(null, routingKey, message, setter);
    }

    @Override
    public void sendWithNoConfirm(String exchange, String routingKey, Object message, MessagePropertiesSetter setter) {
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Message deliverying with no confirm ... to exchange: {}", (Object)exchange);
        MessagePostProcessor messagePostProcessor = setter == null ? null : this.convert(setter);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, message, messagePostProcessor);
        LOGGER.debug("The cost times of deliver with no confirm is {}", (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public Boolean sendWithSyncConfirm(String routingKey, Object message) {
        return this.sendWithSyncConfirm(null, routingKey, message, null);
    }

    @Override
    public Boolean sendWithSyncConfirm(String exchange, String routingKey, Object message) {
        return this.sendWithSyncConfirm(exchange, routingKey, message, null);
    }

    @Override
    public Boolean sendWithSyncConfirm(String routingKey, Object message, MessagePropertiesSetter setter) {
        return this.sendWithSyncConfirm(null, routingKey, message, setter);
    }

    @Override
    public Boolean sendWithSyncConfirm(String exchange, String routingKey, Object message, MessagePropertiesSetter setter) {
        try {
            long startTime = System.currentTimeMillis();
            LOGGER.debug("Message deliverying with sync confirm ... to exchange: {}", (Object)exchange);
            LOGGER.debug("Send message waiting for confirmMilli: {}", (Object)this.waitForConfirmMilli);
            Boolean result = (Boolean)this.rabbitTemplate.invoke(operations -> {
                MessagePostProcessor messagePostProcessor = setter == null ? null : this.convert(setter);
                operations.convertAndSend(exchange, routingKey, message, messagePostProcessor);
                return operations.waitForConfirms((long)this.waitForConfirmMilli);
            });
            LOGGER.debug("The cost times of deliver with sync confirm is {} and result is {}", (Object)(System.currentTimeMillis() - startTime), (Object)result);
            return result;
        }
        catch (AmqpException e) {
            if (e.getCause() instanceof TimeoutException) {
                throw new ConfirmTimeoutException(e);
            }
            throw e;
        }
    }

    @Override
    public Boolean sendAndRetryWithSyncConfirm(String routingKey, Object message, int maxRetryCount, int interval) {
        return this.sendAndRetryWithSyncConfirm(null, routingKey, message, null, maxRetryCount, interval);
    }

    @Override
    public Boolean sendAndRetryWithSyncConfirm(String exchange, String routingKey, Object message, int maxRetryCount, int interval) {
        return this.sendAndRetryWithSyncConfirm(exchange, routingKey, message, null, maxRetryCount, interval);
    }

    @Override
    public Boolean sendAndRetryWithSyncConfirm(String routingKey, Object message, MessagePropertiesSetter setter, int maxRetryCount, int interval) {
        return this.sendAndRetryWithSyncConfirm(null, routingKey, message, setter, maxRetryCount, interval);
    }

    @Override
    public Boolean sendAndRetryWithSyncConfirm(String exchange, String routingKey, Object message, MessagePropertiesSetter setter, int maxRetryCount, int interval) {
        try {
            return this.sendWithSyncConfirm(exchange, routingKey, message, setter);
        }
        catch (ConfirmTimeoutException e) {
            int retryCount = maxRetryCount;
            while (retryCount-- > 0) {
                try {
                    if (interval > 0) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(interval);
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    return this.retrySendingWithSyncConfirm(exchange, routingKey, message, setter);
                }
                catch (Exception e1) {
                    LOGGER.error("Retry error.", (Throwable)e1);
                }
            }
            throw e;
        }
    }

    @Override
    public void sendWithAsyncConfirm(String routingKey, Object message, AsynCallback callback) {
        this.sendWithAsyncConfirm(null, routingKey, message, null, callback);
    }

    @Override
    public void sendWithAsyncConfirm(String exchange, String routingKey, Object message, AsynCallback callback) {
        this.sendWithAsyncConfirm(exchange, routingKey, message, null, callback);
    }

    @Override
    public void sendWithAsyncConfirm(String routingKey, Object message, MessagePropertiesSetter setter, AsynCallback callback) {
        this.sendWithAsyncConfirm(null, routingKey, message, setter, callback);
    }

    @Override
    public void sendWithAsyncConfirm(String exchange, String routingKey, Object message, MessagePropertiesSetter setter, AsynCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWaitForConfirmMilli(int waitForConfirmMilli) {
        this.waitForConfirmMilli = waitForConfirmMilli;
    }

    private Boolean retrySendingWithSyncConfirm(String exchange, String routingKey, Object message, MessagePropertiesSetter setter) {
        return (Boolean)this.rabbitTemplate.invoke(operations -> {
            MessageProperties retryMessage = setter == null ? this.getRetryMessageProperties() : this.getRetryMessageProperties(setter);
            operations.convertAndSend(exchange, routingKey, message, this.convert(retryMessage));
            return operations.waitForConfirms((long)this.waitForConfirmMilli);
        });
    }

    private MessageProperties getRetryMessageProperties(MessagePropertiesSetter setter) {
        MessageProperties setting = setter.apply(new MessageProperties());
        Map<String, Object> headers = setting.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, Object>();
            setting.setHeaders(headers);
        }
        headers.put(REDELIVERY_TAG, true);
        return setting;
    }

    private MessageProperties getRetryMessageProperties() {
        MessageProperties setting = new MessageProperties();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(REDELIVERY_TAG, true);
        setting.setHeaders(headers);
        return setting;
    }

    private MessagePostProcessor convert(MessagePropertiesSetter setter) {
        MessageProperties setting = setter.apply(new MessageProperties());
        return this.convert(setting);
    }

    private MessagePostProcessor convert(MessageProperties setting) {
        return msg -> {
            msg.getMessageProperties().setPriority(setting.getPriority());
            msg.getMessageProperties().setContentType(setting.getContentType());
            msg.getMessageProperties().setContentEncoding(setting.getContentEncoding());
            msg.getMessageProperties().setTimestamp(setting.getTimestamp());
            msg.getMessageProperties().setType(setting.getType());
            msg.getMessageProperties().setAppId(setting.getAppId());
            msg.getMessageProperties().setClusterId(setting.getClusterId());
            msg.getMessageProperties().setCorrelationId(setting.getCorrelationId());
            Integer deliveryMode = setting.getDeliveryMode();
            if (deliveryMode != null) {
                msg.getMessageProperties().setDeliveryMode(MessageDeliveryMode.fromInt((int)deliveryMode));
            }
            msg.getMessageProperties().setReplyTo(setting.getReplyTo());
            msg.getMessageProperties().setMessageId(setting.getMessageId());
            msg.getMessageProperties().setUserId(setting.getUserId());
            msg.getMessageProperties().setExpiration(setting.getExpiration());
            setting.getHeaders().forEach((arg_0, arg_1) -> ((org.springframework.amqp.core.MessageProperties)msg.getMessageProperties()).setHeader(arg_0, arg_1));
            return msg;
        };
    }
}

