/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.service;

import com.ericsson.cms.neptune.rabbitmq.service.RabbitMQServiceArguments;
import com.ericsson.cms.neptune.rabbitmq.service.listener.RabbitMQConnectionListener;
import com.ericsson.cms.neptune.rabbitmq.util.MQPropertyLoader;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.ConnectionFactory;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;

@EnableRabbit
@Configuration
public class RabbitConfiguration {
    private static MQPropertyLoader propertyLoader = new MQPropertyLoader();
    @Autowired(required=false)
    private RabbitMQServiceArguments rabbitMQComponentArguments;

    @Bean
    public org.springframework.amqp.rabbit.connection.ConnectionFactory defaultConnectionFactory() {
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        return this.createCachingConnectionFactory(connectionFactory);
    }

    @Bean
    public RabbitAdmin defaultRabbitAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    public RabbitTemplate defaultRabbitTemplate(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory, ApplicationContext applicationContext) {
        RabbitTemplate template = RabbitConfiguration.newDefaultInstance(connectionFactory);
        this.customizeDefaultRabbitTemplate(template, applicationContext);
        return template;
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory, RabbitTemplate rabbitTemplate) {
        SimpleRabbitListenerContainerFactory factory = RabbitConfiguration.newDefaultContainerFactory(connectionFactory);
        factory.setMessageConverter(rabbitTemplate.getMessageConverter());
        return factory;
    }

    private ConnectionFactory createConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setConnectionTimeout(propertyLoader.getConnectionTimeOut());
        connectionFactory.setTopologyRecoveryEnabled(propertyLoader.isTopologyRecoveyEnabled());
        connectionFactory.setAutomaticRecoveryEnabled(false);
        if (propertyLoader.isSSLEnabled()) {
            try {
                connectionFactory.useSslProtocol(propertyLoader.createSSLContext());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't setup SSL for ConnectionFactory.", e);
            }
        }
        return connectionFactory;
    }

    private CachingConnectionFactory createCachingConnectionFactory(ConnectionFactory connectionFactory) {
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory(connectionFactory);
        cachingConnectionFactory.setUsername(propertyLoader.getUserName());
        cachingConnectionFactory.setPassword(propertyLoader.getPassword());
        cachingConnectionFactory.setAddresses(this.getNodeAddress());
        cachingConnectionFactory.setPublisherConfirmType(CachingConnectionFactory.ConfirmType.CORRELATED);
        cachingConnectionFactory.addConnectionListener((ConnectionListener)new RabbitMQConnectionListener());
        this.initWithRabbitMQComponentArguments(cachingConnectionFactory);
        return cachingConnectionFactory;
    }

    private void initWithRabbitMQComponentArguments(CachingConnectionFactory cachingConnectionFactory) {
        if (this.rabbitMQComponentArguments != null) {
            Integer channelCacheSize;
            String connectionName = this.rabbitMQComponentArguments.getConnectionName();
            if (StringUtils.isNotBlank((String)connectionName)) {
                cachingConnectionFactory.setConnectionNameStrategy(factory -> connectionName);
            }
            if ((channelCacheSize = this.rabbitMQComponentArguments.getConnectionFactoryChannelCacheSize()) != null) {
                cachingConnectionFactory.setChannelCacheSize(channelCacheSize.intValue());
            }
        }
    }

    private void customizeDefaultRabbitTemplate(RabbitTemplate template, ApplicationContext applicationContext) {
        Collection customizers = applicationContext.getBeansOfType(DefaultRabbitTemplateCustomizer.class).values();
        for (DefaultRabbitTemplateCustomizer customizer : customizers) {
            customizer.customize(template);
        }
    }

    private String getNodeAddress() {
        StringBuilder sb = new StringBuilder();
        try {
            List<Address> nodeAddresses = propertyLoader.getNodeAddresses();
            for (Address address : nodeAddresses) {
                sb.append(address.toString()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("can't get RabbitMQ node address", e);
        }
    }

    public static RabbitTemplate newDefaultInstance(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        RabbitTemplate template = new RabbitTemplate(connectionFactory);
        template.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        template.setUsePublisherConnection(true);
        template.setRetryTemplate(RabbitConfiguration.getRetryTemplate());
        return template;
    }

    public static SimpleRabbitListenerContainerFactory newDefaultContainerFactory(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        factory.setPrefetchCount(Integer.valueOf(1));
        factory.setDefaultRequeueRejected(Boolean.valueOf(false));
        return factory;
    }

    private static RetryTemplate getRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
        backOffPolicy.setBackOffPeriod(0L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(1);
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }

    public static interface DefaultRabbitTemplateCustomizer {
        public void customize(RabbitTemplate var1);
    }
}

