/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.service;

import com.ericsson.cms.neptune.rabbitmq.service.RabbitConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.util.Assert;

public class RabbitMQService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQService.class);
    private ApplicationContext parentContext;
    private ConfigurableApplicationContext context;
    private Class<?>[] configurationClasses;

    public RabbitMQService(Class<?> ... configurationClasses) {
        Assert.notNull(configurationClasses, (String)"configurationClasses can't be null");
        ArrayList<Class<RabbitConfiguration>> result = new ArrayList<Class<RabbitConfiguration>>();
        result.add(RabbitConfiguration.class);
        if (configurationClasses.length > 0) {
            Collections.addAll(result, configurationClasses);
        }
        this.configurationClasses = result.toArray(new Class[result.size()]);
    }

    public RabbitMQService(ApplicationContext parentContext, Class<?> ... configurationClasses) {
        this(configurationClasses);
        this.parentContext = parentContext;
    }

    public synchronized void start() {
        if (this.context != null) {
            return;
        }
        LOGGER.info("Startup Spring context.");
        long start = System.currentTimeMillis();
        this.context = new AnnotationConfigApplicationContext((Class[])this.configurationClasses);
        if (this.parentContext != null) {
            this.context.setParent(this.parentContext);
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Startup Spring context success. Spend time: {}ms", (Object)(end - start));
    }

    public synchronized void stop() {
        if (this.context == null) {
            return;
        }
        this.context.close();
        this.context = null;
    }

    public <T extends RabbitTemplate> T getRabbitTemplate() {
        this.checkInit();
        return (T)((RabbitTemplate)this.context.getBean(RabbitTemplate.class));
    }

    public RabbitAdmin getRabbitAdmin() {
        this.checkInit();
        return (RabbitAdmin)this.context.getBean(RabbitAdmin.class);
    }

    public void startConsumer(String consumerId) {
        MessageListenerContainer listenerContainer = this.getConsumer(consumerId);
        listenerContainer.start();
    }

    public void stopConsumer(String consumerId) {
        MessageListenerContainer listenerContainer = this.getConsumer(consumerId);
        listenerContainer.stop();
    }

    private MessageListenerContainer getConsumer(String consumerId) {
        RabbitListenerEndpointRegistry registry = (RabbitListenerEndpointRegistry)this.context.getBean(RabbitListenerEndpointRegistry.class);
        MessageListenerContainer listenerContainer = registry.getListenerContainer(consumerId);
        if (listenerContainer == null) {
            throw new IllegalArgumentException("No consumer with consumerId " + consumerId);
        }
        return listenerContainer;
    }

    private void checkInit() {
        if (this.context == null) {
            throw new IllegalStateException("Spring container is not startup");
        }
    }
}

