/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.service.listener;

import com.ericsson.cms.neptune.rabbitmq.service.listener.ConnectionBlockedListener;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;

public class RabbitMQConnectionListener
implements ConnectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQConnectionListener.class);
    private static final ConnectionBlockedListener BLOCKED_LISTENER = new ConnectionBlockedListener();

    public void onCreate(Connection connection) {
        connection.addBlockedListener((BlockedListener)BLOCKED_LISTENER);
    }

    public void onClose(Connection connection) {
    }

    public void onShutDown(ShutdownSignalException cause) {
        Object connectionOrChannel = cause.getReference();
        com.rabbitmq.client.Connection connection = null;
        Channel channel = null;
        if (connectionOrChannel instanceof com.rabbitmq.client.Connection) {
            connection = (com.rabbitmq.client.Connection)connectionOrChannel;
        } else if (connectionOrChannel instanceof Channel) {
            channel = (Channel)connectionOrChannel;
            connection = channel.getConnection();
        }
        if (LOGGER.isDebugEnabled()) {
            if (channel != null) {
                LOGGER.debug("RabbitMQ Connection[" + connection + "] is shutdown because of error on Channel [" + channel + "].");
            } else if (!cause.isInitiatedByApplication()) {
                LOGGER.debug("RabbitMQ Connection[" + connectionOrChannel + "] is shutdown because of Connection error and the error is initialized by application.");
            } else {
                LOGGER.debug("RabbitMQ Connection[" + connectionOrChannel + "] is shutdown because of Connection error and the error is NOT initialized by application..");
            }
        }
        LOGGER.info("RabbitMQ Connection[" + connectionOrChannel + "] is shutdown, reason:[" + cause.getReason() + "]; cause: " + cause.getCause());
    }
}

