/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.neptune.rabbitmq.util;

import com.ericsson.cms.neptune.rabbitmq.configuration.ConfigConstants;
import com.ericsson.cms.neptune.rabbitmq.configuration.ConfigDefaultValue;
import com.ericsson.cms.neptune.rabbitmq.util.IMQConfiguration;
import com.ericsson.cms.neptune.rabbitmq.util.SSLUtil;
import com.rabbitmq.client.Address;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MQPropertyLoader
implements ConfigConstants,
ConfigDefaultValue,
IMQConfiguration {
    private static final Logger LOGGER = Logger.getLogger(MQPropertyLoader.class);
    private Properties props;
    private String configFilePath = ConfigConstants.MQ_CONFIG_PATH;

    public MQPropertyLoader() {
        this.loadProperties();
    }

    public MQPropertyLoader(String configFilePath) {
        this.configFilePath = configFilePath;
        this.loadProperties();
    }

    private void loadProperties() {
        this.props = new Properties();
        File configFile = new File(this.configFilePath);
        if (!configFile.exists() || !configFile.isFile()) {
            LOGGER.info((Object)"Can not find configuration file for RabbitMQ, will use default values.");
            return;
        }
        try {
            this.props.load(new FileInputStream(this.configFilePath));
        }
        catch (IOException e) {
            LOGGER.warn((Object)("cannot open file[" + this.configFilePath + "], use default configurations, error: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public List<Address> getNodeAddresses() throws UnknownHostException {
        boolean isSSL = this.getBooleanField("mq.ssl.enabled", "false");
        String addrList = this.getStringField("mq.address.list", "");
        if (StringUtils.isBlank((String)addrList) || this.isEmptyAddressList(addrList)) {
            return this.getAddressFromDNS(this.getStringField("mq.address.dns", "app-nodes.service"), isSSL);
        }
        return Arrays.stream(addrList.split(",")).map(addr -> {
            if (StringUtils.isBlank((String)addr)) {
                return null;
            }
            String[] segments = addr.trim().split(":");
            if (segments.length == 1) {
                return new Address(segments[0], this.getDefaultPort(isSSL));
            }
            return new Address(segments[0], Integer.parseInt(segments[1]));
        }).filter(addr -> addr != null).collect(Collectors.toList());
    }

    private boolean isEmptyAddressList(String addrList) {
        String[] addresses = addrList.split(",");
        for (int i = 0; i < addresses.length; ++i) {
            if (!StringUtils.isNotEmpty((String)addresses[i].trim())) continue;
            return false;
        }
        return true;
    }

    private List<Address> getAddressFromDNS(String dnsName, boolean isSSL) throws UnknownHostException {
        InetAddress[] address = this.dnsLookup(dnsName);
        return Arrays.stream(address).map(addr -> new Address(addr.getHostAddress(), this.getDefaultPort(isSSL))).collect(Collectors.toList());
    }

    private int getDefaultPort(boolean isSSL) {
        return isSSL ? 5671 : 5672;
    }

    private InetAddress[] dnsLookup(String dnsName) throws UnknownHostException {
        return InetAddress.getAllByName(dnsName);
    }

    private SSLContext createSSLContext(String keystore, String keystorePass, String truststore, String truststorePass) throws Exception {
        return SSLUtil.createContext(keystore, keystorePass, truststore, truststorePass);
    }

    public String getStringField(String fieldName, String defaultValue) {
        String value = this.props.getProperty(fieldName);
        return StringUtils.isBlank((String)value) ? defaultValue : value;
    }

    public int getIntField(String fieldName, String defaultValue) {
        String value = this.props.getProperty(fieldName);
        int intValue = 0;
        try {
            intValue = Integer.parseInt(StringUtils.isBlank((String)value) ? defaultValue : value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Parse String value [" + value + "] to int failed, the default value " + defaultValue + "will be used."), (Throwable)e);
            intValue = Integer.parseInt(defaultValue);
        }
        return intValue;
    }

    public Long getLongField(String fieldName, String defaultValue) {
        String value = this.props.getProperty(fieldName);
        long longValue = 0L;
        try {
            longValue = Long.parseLong(StringUtils.isBlank((String)value) ? defaultValue : value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Parse String value [" + value + "] to long failed, the default value " + defaultValue + "will be used."), (Throwable)e);
            longValue = Long.parseLong(defaultValue);
        }
        return longValue;
    }

    public boolean getBooleanField(String fieldName, String defaultValue) {
        String value = this.props.getProperty(fieldName);
        return Boolean.parseBoolean(StringUtils.isBlank((String)value) ? defaultValue : value);
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public int getWaitForConfirm(int defaultValue) {
        return this.getIntField("publish.confirm.timeout", String.valueOf(defaultValue));
    }

    public long getWaitingInterval(long defaultValue) {
        return this.getLongField("consumer.waiting.interval", String.valueOf(defaultValue));
    }

    public int getConsumerQoS(int defaultValue) {
        return this.getIntField("consumer.prefetch.count", String.valueOf(defaultValue));
    }

    @Override
    public String getUserName() {
        return this.getStringField("mq.username", "cms");
    }

    @Override
    public String getPassword() {
        return this.getStringField("mq.password", "cms1234");
    }

    @Override
    public int getConnectionTimeOut() {
        return this.getIntField("mq.connection.timeout", "5000");
    }

    @Override
    public boolean isAutoRecoveryEnabled() {
        return this.getBooleanField("mq.connection.autorecover", "true");
    }

    @Override
    public boolean isTopologyRecoveyEnabled() {
        return this.getBooleanField("mq.connection.topologyrecover", "true");
    }

    @Override
    public boolean isSSLEnabled() {
        return this.getBooleanField("mq.ssl.enabled", "false");
    }

    public SSLContext createSSLContext() throws Exception {
        return this.createSSLContext(this.props.getProperty("mq.ssl.keystore"), this.props.getProperty("mq.ssl.keystore.pass"), this.props.getProperty("mq.ssl.truststore"), this.props.getProperty("mq.ssl.truststore.pass"));
    }

    @Override
    public int getNetworkRecoveryInterval() {
        return this.getIntField("mq.connection.autorecover.interval", "3000");
    }
}

