/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.provider.mf;

import com.ericsson.neptune.security.util.JsonUtil;
import com.ericsson.neptune.security.util.RestHelper;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class MFAuthClient {
    private static final Logger LOG = Logger.getLogger(MFAuthClient.class);
    public static final String MF_AUTH_SERVER_PROP_KEY = "com.ericsson.neptune.security.mf.authServer";
    private static final String TOKEN_VERIFY_API = "/operatorsts/v1/verifytoken";
    private static final String TOKEN_EXPIRATION_KEY = "Expiration";
    private static final DateTimeFormatter TOKEN_EXPIRATION_FORMATTER = DateTimeFormatter.ISO_INSTANT;
    private static RestHelper restHelper = new RestHelper();
    private String mfAuthServer;

    public MFAuthClient(String mfAuthServer) {
        this.mfAuthServer = mfAuthServer;
    }

    public String verifyToken(String accessToken) {
        String requestUri = this.mfAuthServer + TOKEN_VERIFY_API;
        String authorizationHeader = String.format("OAUTH2 access_token=\"%s\"", accessToken);
        return restHelper.makeGetRequest(requestUri, authorizationHeader);
    }

    public boolean checkTokenValid(String accessToken) {
        String rawResponse = this.verifyToken(accessToken);
        Optional<Map<String, Object>> optionalMap = JsonUtil.convertJsonToMap(rawResponse);
        if (optionalMap.isPresent()) {
            String expiredTime = (String)optionalMap.get().get(TOKEN_EXPIRATION_KEY);
            if (expiredTime == null) {
                return false;
            }
            try {
                Instant expirationDate = Instant.from(TOKEN_EXPIRATION_FORMATTER.parse(expiredTime));
                return Instant.now().isBefore(expirationDate);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage());
                LOG.debug((Object)e);
            }
        }
        return false;
    }

    public Optional<Instant> getTokenExpirationTime(String accessToken) {
        String rawResponse = this.verifyToken(accessToken);
        Optional<Map<String, Object>> optionalMap = JsonUtil.convertJsonToMap(rawResponse);
        if (optionalMap.isPresent()) {
            String expiredTime = (String)optionalMap.get().get(TOKEN_EXPIRATION_KEY);
            if (expiredTime == null) {
                return Optional.empty();
            }
            try {
                Instant expirationDate = Instant.from(TOKEN_EXPIRATION_FORMATTER.parse(expiredTime));
                return Optional.of(expirationDate);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage());
                LOG.debug((Object)e);
            }
        }
        return Optional.empty();
    }

    public static class MFAuthClientHolder {
        private static volatile MFAuthClient instance;
        private static final MFAuthClientHolder authClientHolder;
        private String mfAuthServer;

        public static void authServer(String authServer) {
            MFAuthClientHolder.authClientHolder.mfAuthServer = authServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static MFAuthClient get() {
            if (instance != null) return instance;
            Class<MFAuthClientHolder> clazz = MFAuthClientHolder.class;
            synchronized (MFAuthClientHolder.class) {
                if (instance != null) return instance;
                if (Objects.isNull(MFAuthClientHolder.authClientHolder.mfAuthServer)) {
                    MFAuthClientHolder.authClientHolder.mfAuthServer = System.getProperty(MFAuthClient.MF_AUTH_SERVER_PROP_KEY);
                }
                instance = new MFAuthClient(MFAuthClientHolder.authClientHolder.mfAuthServer);
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        static {
            authClientHolder = new MFAuthClientHolder();
        }
    }
}

