/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.provider.mf;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.ForwardingCache;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class MFTokenCache
extends ForwardingCache.SimpleForwardingCache<String, Instant> {
    private MFTokenCache(Cache<String, Instant> delegate) {
        super(delegate);
    }

    public Instant getIfPresent(Object key) {
        Instant expirationTime = (Instant)this.delegate().getIfPresent(key);
        if (expirationTime != null) {
            if (Instant.now().isBefore(expirationTime)) {
                return expirationTime;
            }
            this.delegate().invalidate(key);
        }
        return null;
    }

    public Instant get(String key, Callable<? extends Instant> valueLoader) throws ExecutionException {
        Instant expirationTime = (Instant)this.delegate().get((Object)key, valueLoader);
        if (expirationTime != null && Instant.now().isAfter(expirationTime)) {
            this.delegate().invalidate((Object)key);
            throw new ExecutionException(key + " is expired.", null);
        }
        return expirationTime;
    }

    static MFTokenCache getInstance() {
        return MFTokenCacheHolder.instance;
    }

    private static class MFTokenCacheHolder {
        public static final MFTokenCache instance = new MFTokenCache(CacheBuilder.newBuilder().maximumSize(10000L).build());

        private MFTokenCacheHolder() {
        }
    }
}

