/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.provider.mf;

import com.ericsson.neptune.security.provider.mf.MFAuthClient;
import com.ericsson.neptune.security.provider.mf.MFTokenCache;
import com.google.common.cache.Cache;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;

public class MFTokenHelper {
    private static final Logger LOG = Logger.getLogger(MFTokenHelper.class);
    private static final String MF_TOKEN_PREFIX = "OAUTH2 access_token";

    public boolean isTokenValid(String accessToken) {
        boolean isAccessTokenVerified;
        if (!this.quickValidate(accessToken)) {
            LOG.debug((Object)String.format("Access token <%s> is with invalid format.", accessToken));
            return false;
        }
        Cache<String, Instant> mfTokenCache = MFTokenHelper.getMFTokenCache();
        Instant cachedToken = (Instant)mfTokenCache.getIfPresent((Object)accessToken);
        if (Objects.nonNull(cachedToken)) {
            LOG.debug((Object)String.format("Access token <%s> is found in cache", accessToken));
            return true;
        }
        MFAuthClient client = MFAuthClient.MFAuthClientHolder.get();
        Optional<Instant> optionalExpirationTime = client.getTokenExpirationTime(accessToken);
        boolean bl = isAccessTokenVerified = optionalExpirationTime.isPresent() && Instant.now().isBefore(optionalExpirationTime.get());
        if (isAccessTokenVerified) {
            MFTokenHelper.getMFTokenCache().put((Object)accessToken, (Object)optionalExpirationTime.get());
            LOG.debug((Object)String.format("Access token <%s> is verified.", accessToken));
            return true;
        }
        return false;
    }

    private boolean quickValidate(String accessToken) {
        return !Objects.isNull(accessToken);
    }

    public static Cache<String, Instant> getMFTokenCache() {
        return MFTokenCache.getInstance();
    }
}

