/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.security.util;

import com.ericsson.neptune.security.util.EncodingUtils;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class HttpURLUtil {
    private static final String HASH_MARK = "#";
    private static final String QUERY_MARK = "?";
    private static final String EMPTY_STR = "";
    private static final Logger LOG = Logger.getLogger(HttpURLUtil.class);

    private HttpURLUtil() {
    }

    public static String buildBaseURL(String requestUrl) {
        URL url = null;
        try {
            url = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e.getMessage());
        }
        if (url == null) {
            return EMPTY_STR;
        }
        StringBuilder baseUrlBuidler = new StringBuilder();
        baseUrlBuidler.append(url.getProtocol()).append("://").append(url.getAuthority());
        return baseUrlBuidler.toString();
    }

    public static Map<String, String> buildQueryParamMapFromUrl(String requestUrl) {
        String queryStr = null;
        try {
            queryStr = new URL(requestUrl).getQuery();
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)e);
            return Collections.emptyMap();
        }
        return HttpURLUtil.parseQueryString(queryStr);
    }

    public static Map<String, String> parseQueryString(String queryStr) {
        if (Strings.isNullOrEmpty((String)queryStr)) {
            return Maps.newLinkedHashMap();
        }
        List pairs = Splitter.on((String)"&").trimResults().splitToList((CharSequence)queryStr);
        return pairs.stream().map(s -> s.split("=", 2)).collect(Collectors.toMap(pair -> pair[0], pair -> ((String[])pair).length > 1 ? pair[1] : EMPTY_STR, (former, latter) -> latter, LinkedHashMap::new));
    }

    public static String buildQueryString(Map<String, String> parameterMap) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return EMPTY_STR;
        }
        return parameterMap.entrySet().stream().map(Object::toString).collect(Collectors.joining("&"));
    }

    public static String appendParameterToRequestUrl(String requestUrl, String name, String value) {
        URL url = null;
        try {
            url = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)("request url is invalid: " + requestUrl));
            LOG.debug((Object)e);
            return EMPTY_STR;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url.getProtocol()).append("://").append(url.getAuthority()).append(url.getPath());
        String queryStr = url.getQuery();
        String hashLocaltion = url.getRef();
        if (Strings.isNullOrEmpty((String)queryStr)) {
            urlBuilder.append(QUERY_MARK).append(name).append("=").append(EncodingUtils.encodeURL(value, StandardCharsets.UTF_8.name()));
        } else {
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>(HttpURLUtil.parseQueryString(queryStr));
            paramMap.put(name, value);
            queryStr = HttpURLUtil.buildQueryString(paramMap);
            urlBuilder.append(QUERY_MARK).append(queryStr);
        }
        if (!Strings.isNullOrEmpty((String)hashLocaltion)) {
            urlBuilder.append(HASH_MARK).append(hashLocaltion);
        }
        return urlBuilder.toString();
    }

    public static String removeParameterFromRequestUrl(String requestUrl, String name) {
        URL url = null;
        try {
            url = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)("request url is invalid: " + requestUrl));
            LOG.debug((Object)e);
            return EMPTY_STR;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url.getProtocol()).append("://").append(url.getAuthority()).append(url.getPath());
        String queryStr = url.getQuery();
        String hashLocaltion = url.getRef();
        if (Strings.isNullOrEmpty((String)queryStr)) {
            return requestUrl;
        }
        Map<String, String> paramMap = HttpURLUtil.parseQueryString(queryStr);
        paramMap.remove(name);
        queryStr = HttpURLUtil.buildQueryString(paramMap);
        urlBuilder.append(QUERY_MARK).append(queryStr);
        if (!Strings.isNullOrEmpty((String)hashLocaltion)) {
            urlBuilder.append(HASH_MARK).append(hashLocaltion);
        }
        return urlBuilder.toString();
    }

    public static boolean isAbsoluteURL(String requestUrl) {
        return HttpURLUtil.isValidURL(requestUrl) && requestUrl.contains("://");
    }

    public static boolean isValidURL(String requestUrl) {
        try {
            new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            LOG.debug((Object)e);
            return false;
        }
        return true;
    }
}

