/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.alerts.entity;

import com.ericsson.neptune.alerts.entity.RecoveryOption;
import com.ericsson.neptune.alerts.entity.SeverityType;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Alert
implements Serializable {
    private static final long serialVersionUID = 3492546004528025512L;
    private Date time;
    private String objectId;
    private String type;
    private SeverityType severity;
    private String message;
    private Map<String, String> localizedMessages;
    private String detailedMessage;
    private List<RecoveryOption> recoveryOptions;

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityType severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public List<RecoveryOption> getRecoveryOptions() {
        return this.recoveryOptions;
    }

    public void setRecoveryOptions(List<RecoveryOption> recoveryOptions) {
        this.recoveryOptions = recoveryOptions;
    }

    public String getLocalizedMessages(String locale) {
        String value = this.localizedMessages.get(locale);
        if (StringUtils.isEmpty((String)value)) {
            return this.localizedMessages.get("en_US");
        }
        return value;
    }

    public void setLocalizedMessages(Map<String, String> localizedMessages) {
        this.localizedMessages = localizedMessages;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Alert{");
        builder.append("time=").append(this.time).append(", ");
        builder.append("objectId=").append(this.objectId).append(", ");
        builder.append("type=").append(this.type).append(", ");
        builder.append("severity=").append((Object)this.severity).append(", ");
        builder.append("message=").append(this.message).append(", ");
        String string = Joiner.on((String)",").withKeyValueSeparator("=").join(this.localizedMessages);
        builder.append("localizedMessages=").append("[").append(string).append("], ");
        builder.append("recoveryOptions=[");
        if (this.recoveryOptions != null) {
            for (RecoveryOption option : this.recoveryOptions) {
                builder.append(option).append(", ");
            }
        }
        builder.append("]}");
        return builder.toString();
    }
}

