/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.i18n.util;

import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.i18n.service.I18nResourceServiceFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.LocaleUtils;

public class ServiceMessageBundleUtil {
    private static MessageBundle messageBundle;
    private static final String ADMIN_GROUP = "admin";
    private static final String SETTINGS_GROUP = "settings";
    private static final String DISPLAYNAME_SUFFIX = ".DisplayName";
    private static final String HELPTEXT_SUFFIX = ".HelpText";

    private ServiceMessageBundleUtil() {
    }

    public static MessageBundle getMessageBundle() {
        if (messageBundle == null) {
            I18nResourceService i18nResourceService = I18nResourceServiceFactory.getI18nResourceService();
            messageBundle = i18nResourceService.getMessageBundleInstance();
        }
        return messageBundle;
    }

    public static String getAdminLocaleValueWithoutArguments(String localeKey, String defaultValue, String locale) {
        return ServiceMessageBundleUtil.getMessageBundle().getMessageValue(localeKey, ADMIN_GROUP, defaultValue, LocaleUtils.toLocale((String)locale));
    }

    public static String getAdminLocaleValue(String localeKey, String defaultValue, String locale, Object ... arguments) {
        return ServiceMessageBundleUtil.getMessageBundle().getMessageValue(localeKey, ADMIN_GROUP, defaultValue, LocaleUtils.toLocale((String)locale), arguments);
    }

    public static String getSettingsLocaleDiplayName(String path, String defaultValue, String locale) {
        return ServiceMessageBundleUtil.getMessageBundle().getMessageValue(path + DISPLAYNAME_SUFFIX, SETTINGS_GROUP, defaultValue, LocaleUtils.toLocale((String)locale));
    }

    public static String getSettingsLocaleHelpText(String path, String defaultValue, String locale) {
        return messageBundle.getMessageValue(path + HELPTEXT_SUFFIX, SETTINGS_GROUP, defaultValue, LocaleUtils.toLocale((String)locale));
    }

    public static List<LocalizedString> createLocalizedParam(String value) {
        LocalizedString localizedString = new LocalizedString();
        localizedString.setValue(value);
        ArrayList<LocalizedString> list = new ArrayList<LocalizedString>();
        list.add(localizedString);
        return list;
    }
}

