/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.util;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class GlobalDateFormatUtil {
    public static final String DATE_TIME_PATH = "com.ericsson.cms.neptune.datetime";
    public static final String DATE_FORMAT_KEY = "global_date_format";
    public static final String TIME_FORMAT_KEY = "global_time_format";
    public static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    public static final String COMMON_DATE_TIME_FORMART = "yyyy-MM-dd HH:mm:ss";
    public static final String COMMON_DATE_FORMAT = "yyyy-MM-dd";
    public static final String COMMON_TIME_FORMAT = "HH:mm:ss";
    public static final String TIME_FORMAT_WITH_AMPM = "hh:mm:ss a";
    public static final String HOUR_MIUTE_FORMAT = "HH:mm";
    public static final String HOUR_MIUTE_FORMAT_WITH_AMPM = "hh:mm a";
    public static final String ES_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String DATE_TIME_FORMAT_WITH_T_DELIMITER = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String WORK_ORDER_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final String DB_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
    public static final String SCHEDULE_DATE_TIME_FORMAT = "EEE, MMM d, yyyy h:mm a";
    public static final String AMPM_FORMAT = "a";
    public static final String MILISECOND_FORMAT = "SSS";
    public static final String MILISECOND_WITH_DELIMITER_FORMAT = ":SSS";
    public static final String SECONDS_FORMAT = "ss";
    public static final String DATE_TIME_DELIMITER = " ";
    protected static IConfigurationService configurationService;

    private GlobalDateFormatUtil() {
    }

    public static String formatDateTime(Date date) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE);
        return GlobalDateFormatUtil.formatDateTime(localDateTime);
    }

    public static String formatDateTime(Date date, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE);
        return GlobalDateFormatUtil.formatDateTime(localDateTime, pattern);
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        return dateTime.format(GlobalDateFormatUtil.getDateTimeFormatter());
    }

    public static String formatDateTime(LocalDateTime dateTime, String pattern) {
        return dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDateTimeWithMilliSeconds(Date date, String pattern) {
        String milliSecondPattern = GlobalDateFormatUtil.enhanceMilliSecondPattern(pattern);
        return GlobalDateFormatUtil.formatDateTime(date, milliSecondPattern);
    }

    public static String formatDate(Date date) {
        LocalDate localDate = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE).toLocalDate();
        return GlobalDateFormatUtil.formatDate(localDate);
    }

    public static String formatDate(Date date, String pattern) {
        LocalDate localDate = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE).toLocalDate();
        return GlobalDateFormatUtil.formatDate(localDate, pattern);
    }

    public static String formatDate(LocalDate date) {
        return date.format(GlobalDateFormatUtil.getDateFormatter());
    }

    public static String formatDate(LocalDate date, String pattern) {
        return date.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatTime(Date date) {
        LocalTime localTime = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE).toLocalTime();
        return GlobalDateFormatUtil.formatTime(localTime);
    }

    public static String formatTime(Date date, String pattern) {
        LocalTime localTime = LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE).toLocalTime();
        return GlobalDateFormatUtil.formatTime(localTime, pattern);
    }

    public static String formatTimeWithMilliSecond(Date date, String pattern) {
        String milliSecondPattern = GlobalDateFormatUtil.enhanceMilliSecondPattern(pattern);
        return GlobalDateFormatUtil.formatTime(date, milliSecondPattern);
    }

    public static String formatTime(LocalTime time) {
        return time.format(GlobalDateFormatUtil.getTimeFormatter());
    }

    public static String formatTime(LocalTime time, String pattern) {
        return time.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, GlobalDateFormatUtil.getDateTimeFormatter());
    }

    public static LocalDateTime parseDateTime(String dateTime, String pattern) {
        return LocalDateTime.parse(dateTime, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDateTime parseDateTimeWithMilliSecond(String dateTime, String pattern) {
        String milliSecondPattern = GlobalDateFormatUtil.enhanceMilliSecondPattern(pattern);
        return GlobalDateFormatUtil.parseDateTime(dateTime, milliSecondPattern);
    }

    public static LocalDate parseDate(String date) {
        return LocalDate.parse(date, GlobalDateFormatUtil.getDateFormatter());
    }

    public static LocalDate parseDate(String date, String pattern) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseTime(String time) {
        return LocalTime.parse(time, GlobalDateFormatUtil.getTimeFormatter());
    }

    public static LocalTime parseTime(String time, String pattern) {
        return LocalTime.parse(time, DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalTime parseTimeWithMilliSecond(String time, String pattern) {
        String milliSecondPattern = GlobalDateFormatUtil.enhanceMilliSecondPattern(pattern);
        return GlobalDateFormatUtil.parseTime(time, milliSecondPattern);
    }

    public static String changeDateTimeFormat(String dateStr, String oldFormat, String newFormat) {
        return GlobalDateFormatUtil.formatDateTime(GlobalDateFormatUtil.parseDateTime(dateStr, oldFormat), newFormat);
    }

    public static String changeDateFormat(String dateStr, String oldFormat, String newFormat) {
        return GlobalDateFormatUtil.formatDate(GlobalDateFormatUtil.parseDate(dateStr, oldFormat), newFormat);
    }

    public static String changeTimeFormat(String dateStr, String oldFormat, String newFormat) {
        return GlobalDateFormatUtil.formatTime(GlobalDateFormatUtil.parseTime(dateStr, oldFormat), newFormat);
    }

    public static Date fromLocalDateTime(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(DEFAULT_ZONE).toInstant());
    }

    public static Date fromLocalDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(DEFAULT_ZONE).toInstant());
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(GlobalDateFormatUtil.getDateTimeFormat());
    }

    public static DateTimeFormatter getDateFormatter() {
        return DateTimeFormatter.ofPattern(GlobalDateFormatUtil.getDateFormat());
    }

    public static DateTimeFormatter getTimeFormatter() {
        return DateTimeFormatter.ofPattern(GlobalDateFormatUtil.getTimeFormat());
    }

    public static String getDateTimeFormat() {
        return GlobalDateFormatUtil.getDateFormat() + DATE_TIME_DELIMITER + GlobalDateFormatUtil.getTimeFormat();
    }

    public static String getDateFormat() {
        return GlobalDateFormatUtil.getConfigurationService().getProperties(DATE_TIME_PATH).get(DATE_FORMAT_KEY);
    }

    public static String getTimeFormat() {
        return GlobalDateFormatUtil.getConfigurationService().getProperties(DATE_TIME_PATH).get(TIME_FORMAT_KEY);
    }

    private static String enhanceMilliSecondPattern(String pattern) {
        if (!pattern.contains(SECONDS_FORMAT) || pattern.contains(MILISECOND_FORMAT)) {
            return pattern;
        }
        if (!pattern.endsWith(AMPM_FORMAT)) {
            return pattern + MILISECOND_WITH_DELIMITER_FORMAT;
        }
        return pattern.substring(0, pattern.length() - 1).trim() + MILISECOND_WITH_DELIMITER_FORMAT + DATE_TIME_DELIMITER + AMPM_FORMAT;
    }

    private static IConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = InjectionUtil.injectInstance("cms/ConfigurationService/local", IConfigurationService.class);
        }
        return configurationService;
    }
}

