/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.http.servlet;

import com.ericsson.neptune.http.servlet.GZipServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.log4j.Logger;

public class GZipServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOGGER = Logger.getLogger(GZipServletResponseWrapper.class);
    private ServletOutputStream gzipOutputStream = null;
    private PrintWriter printWriter = null;

    public GZipServletResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
    }

    public void flushBuffer() throws IOException {
        if (this.gzipOutputStream != null) {
            this.gzipOutputStream.flush();
        }
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        super.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("PrintWriter obtained already - cannot get OutputStream");
        }
        if (this.gzipOutputStream == null) {
            this.gzipOutputStream = new GZipServletOutputStream((OutputStream)this.getResponse().getOutputStream());
        }
        return this.gzipOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.printWriter == null && this.gzipOutputStream != null) {
            throw new IllegalStateException("OutputStream obtained already - cannot get PrintWriter");
        }
        if (this.printWriter == null) {
            this.gzipOutputStream = new GZipServletOutputStream((OutputStream)this.getResponse().getOutputStream());
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.gzipOutputStream, this.getResponse().getCharacterEncoding()));
        }
        return this.printWriter;
    }

    public void setContentLength(int len) {
    }

    public void finish() {
        try {
            this.flushBuffer();
            if (this.gzipOutputStream != null) {
                this.gzipOutputStream.close();
            }
            if (this.printWriter != null) {
                this.printWriter.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)e.getMessage());
        }
    }
}

