/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.i18n;

import com.google.common.annotations.VisibleForTesting;
import org.apache.log4j.Logger;

public class ThreadScopeLocaleHolder {
    private static final Logger LOGGER = Logger.getLogger(ThreadScopeLocaleHolder.class);
    private static final ThreadLocal<String> THREAD_SCOPE_LOCALE = ThreadLocal.withInitial(() -> "en_US");
    private static ThreadScopeLocaleHolder instance = new ThreadScopeLocaleHolder();

    private ThreadScopeLocaleHolder() {
    }

    public static ThreadScopeLocaleHolder getInstance() {
        return instance;
    }

    @VisibleForTesting
    public static synchronized ThreadScopeLocaleHolder getInstance(String initialLocale) {
        if (instance == null) {
            instance = new ThreadScopeLocaleHolder();
        }
        instance.setThreadScopeLocale(initialLocale);
        return instance;
    }

    @VisibleForTesting
    public static synchronized void reset() {
        if (instance != null) {
            instance = new ThreadScopeLocaleHolder();
        }
    }

    void setThreadScopeLocale(String localeValue) {
        LOGGER.debug((Object)("Setting locale to " + localeValue + " in threadId #" + Thread.currentThread().getId() + " ,threadName #" + Thread.currentThread().getName()));
        THREAD_SCOPE_LOCALE.set(localeValue);
    }

    public String getThreadScopeLocaleValue() {
        return THREAD_SCOPE_LOCALE.get();
    }
}

