/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.alerts.rest.client;

import com.ericsson.neptune.security.util.HttpConnUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import org.apache.log4j.Logger;

public class RestClient {
    int connTimeout = 2000;
    int readTimeout = 4000;
    private static final Logger logger = Logger.getLogger(RestClient.class);

    public RestClient(int readTimeout, int connTimeout) {
        this.readTimeout = readTimeout;
        this.connTimeout = connTimeout;
    }

    @Deprecated
    public String getJsonAlerts(String url) {
        try {
            return this.getAlerts(url);
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)(url + " connection timed-out:" + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "";
    }

    public String getAlerts(String url) throws SocketTimeoutException, Exception {
        HttpURLConnection conn = null;
        try {
            conn = HttpConnUtil.openHttpConnection((String)url);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setConnectTimeout(this.connTimeout);
            conn.setReadTimeout(this.readTimeout);
            if (conn.getResponseCode() == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                String string = builder.toString();
                return string;
            }
            logger.error((Object)(url + " connection failed: HTTP error code : " + conn.getResponseCode() + " response message:" + conn.getResponseMessage()));
            throw new Exception("HTTP call failure, status: " + conn.getResponseCode());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

