/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.cms.service.api.content.ContentServerClient;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ContentServerFileSystemValidator
extends AbstractSettingValidator {
    private Logger logger = Logger.getLogger(ContentServerFileSystemValidator.class);
    private ContentServerClient contentServerClient;

    @Override
    public ValidationResult validate(SettingDefinition setting, String value) {
        if (value == null || value.isEmpty()) {
            return this.getFailValidationResultWithLocalKey(setting, "needValidPath");
        }
        return this.validatePath(setting, value);
    }

    private ContentServerClient getContentServerClient() {
        if (this.contentServerClient == null) {
            this.contentServerClient = new ContentServerClient();
        }
        return this.contentServerClient;
    }

    private ValidationResult validatePath(SettingDefinition setting, String path) {
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("Path", path);
        try {
            Map response = this.getContentServerClient().invokeFileManager("010762", reqParams);
            if ("true".equalsIgnoreCase((String)response.get("FileExistence"))) {
                return this.getSuccessValidationResult();
            }
            return this.getFailValidationResultWithLocalKey(setting, "needValidPath");
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to request filemanager to validate the path: " + path), (Throwable)e);
            return this.getFailValidationResultWithLocalKey(setting, "canNotValidatePath");
        }
    }
}

