/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.IntegerSetting;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class IntegerRangeValidator
extends AbstractSettingValidator {
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        IntegerSetting setting = (IntegerSetting)s;
        ValidationResult result = new ValidationResult();
        if (value != null && !value.trim().isEmpty()) {
            BigInteger max;
            BigInteger intValue = new BigInteger(value);
            String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
            String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocale);
            BigInteger min = setting.getMinimumValue();
            if (min != null && intValue.compareTo(min) < 0) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>(2);
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                ArrayList<LocalizedString> minParam = new ArrayList<LocalizedString>(1);
                minParam.add(new LocalizedString(min.toString(), currentLocale));
                params.add(minParam);
                String message = ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("floatRangeLessError", defaultMessageBundle.getString("floatRangeLessError"), currentLocale);
                result.fail().addMessage("{0} " + message + " {1}", currentLocale, params);
            }
            if ((max = setting.getMaximumValue()) != null && intValue.compareTo(max) > 0) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(max.toString(), currentLocale));
                params.add(maxParam);
                String message = ServiceMessageBundleUtil.getAdminLocaleValueWithoutArguments("floatRangeGreateError", defaultMessageBundle.getString("floatRangeGreateError"), currentLocale);
                result.fail().addMessage("{0} " + message + " {1}", currentLocale, params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

