/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.entity.StringBaseSettingType;
import com.tandbergtv.neptune.configuration.settings.validator.AbstractSettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class StringLengthValidator
extends AbstractSettingValidator {
    private static Logger logger = Logger.getLogger(StringLengthValidator.class);
    private static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");

    @Override
    public ValidationResult validate(SettingDefinition s, String value) {
        ValidationResult result = new ValidationResult();
        if (!(s instanceof StringBaseSettingType)) {
            logger.warn((Object)"this validator cannot be applied on non-StringBaseSettingType, bypassing the validation.");
            result.success();
            return result;
        }
        StringBaseSettingType setting = (StringBaseSettingType)s;
        String currentLocale = I18nLocaleUtil.getThreadScopeLocaleValue();
        String defaultValue = setting.getDisplayName().isEmpty() ? "" : setting.getDisplayName().get(0).getValue();
        String displayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), defaultValue, currentLocale);
        if (value != null && !value.trim().isEmpty()) {
            BigInteger max;
            int length = value.trim().length();
            BigInteger min = setting.getMinimumLength();
            if (min != null && length < min.intValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(min.toString(), currentLocale));
                params.add(maxParam);
                String message = ServiceMessageBundleUtil.getAdminLocaleValue("charactersLongLess", defaultMessageBundle.getString("charactersLongLess"), currentLocale, displayName, min.toString());
                result.fail().addMessage(message, currentLocale, params);
            }
            if ((max = setting.getMaximumLength()) != null && length > max.intValue()) {
                ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
                params.add(ServiceMessageBundleUtil.createLocalizedParam(displayName));
                ArrayList<LocalizedString> maxParam = new ArrayList<LocalizedString>(1);
                maxParam.add(new LocalizedString(max.toString(), currentLocale));
                params.add(maxParam);
                String message = ServiceMessageBundleUtil.getAdminLocaleValue("charactersLongExceed", defaultMessageBundle.getString("charactersLongExceed"), currentLocale, displayName, max.toString());
                result.fail().addMessage(message, currentLocale, params);
            }
        }
        if (!result.hasFailed()) {
            result.success();
        }
        return result;
    }
}

