/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.common;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import com.tandbergtv.neptune.i18n.service.I18nResourceServiceFactory;
import com.tandbergtv.neptune.i18n.service.bundle.ResourceBundleFileNameHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class I18nVariableJavascriptGenerator {
    private static final String SETTING_MAPPING_VAR_PREFIX = "var setting_mapping_dictionary = ";
    private static final String LOCALE_MAP_VAR_PREFIX = "var allLocaleMap = ";
    private I18nResourceService i18nResourceService;
    private static final Locale RESERVED_LOCALE = I18nLocaleUtil.getDefaultLocale();
    private Logger logger = Logger.getLogger(I18nVariableJavascriptGenerator.class);

    public I18nVariableJavascriptGenerator() {
        this.i18nResourceService = I18nResourceServiceFactory.getI18nResourceService();
    }

    public I18nVariableJavascriptGenerator(I18nResourceService i18nResourceService) {
        this.i18nResourceService = i18nResourceService;
    }

    public Set<String> getResourceBundleJson() {
        Locale locale = I18nLocaleUtil.getThreadScopeLocale();
        if (RESERVED_LOCALE.equals(locale)) {
            return Collections.emptySet();
        }
        HashSet resourceBundleJsonSet = Sets.newHashSet();
        try {
            for (ResourceBundle bundle : this.i18nResourceService.getAvilableBundles(locale)) {
                resourceBundleJsonSet.add(this.getResourceBundleJson(bundle, this.buildBundlesMap(bundle)));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to get resource bundle jsons : " + e.getMessage()));
            this.logger.debug((Object)e);
        }
        return resourceBundleJsonSet;
    }

    public String getResourceBundleJsonByGroup(String groupName) {
        Locale locale = I18nLocaleUtil.getThreadScopeLocale();
        if (RESERVED_LOCALE.equals(locale)) {
            return "";
        }
        ResourceBundle bundle = null;
        try {
            bundle = this.i18nResourceService.getAvilableBundles(locale).stream().filter(b -> b.getBaseBundleName().equals(groupName)).findAny().orElse(null);
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to get resource bundle json by groupName # " + groupName));
            this.logger.debug((Object)e);
        }
        if (bundle == null) {
            this.logger.debug((Object)("Cannot find resource bundle by groupName #" + groupName + " with locale " + locale));
            return "";
        }
        return this.getResourceBundleJson(bundle, this.buildBundlesMap(bundle));
    }

    public String getAvaiableLocaleJson() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(LOCALE_MAP_VAR_PREFIX);
            stringBuilder.append(this.getJsonStringFromMap(this.buildAvailableLocaleMap()));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to genarate json for all locale : " + e.getMessage()));
            this.logger.debug((Object)e);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> buildAvailableLocaleMap() {
        Set<Locale> availableLocales = this.i18nResourceService.getAvailableLocales();
        HashMap localesMap = Maps.newHashMapWithExpectedSize((int)availableLocales.size());
        availableLocales.forEach(locale -> localesMap.put(locale.toString(), locale.getDisplayLanguage((Locale)locale) + (locale.getCountry().isEmpty() ? "" : " - " + locale.getDisplayCountry(Locale.ENGLISH))));
        return localesMap;
    }

    private String getJsonStringFromMap(Map<String, String> map) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonString = objectMapper.writeValueAsString(map);
        return Strings.isNullOrEmpty((String)jsonString) ? "{}" : jsonString;
    }

    public String getNeptuneSettingBundleNamesJson() {
        Locale locale = I18nLocaleUtil.getThreadScopeLocale();
        if (RESERVED_LOCALE.equals(locale)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SETTING_MAPPING_VAR_PREFIX);
        HashMap neptuneBundleNameMaps = Maps.newHashMap();
        try {
            this.i18nResourceService.getNeptuneSettingMappingBundleNames().stream().filter(bundleName -> {
                ResourceBundleFileNameHelper resourceBundleFileNameHelper = ResourceBundleFileNameHelper.parseFileName(bundleName);
                return resourceBundleFileNameHelper != null && locale.equals(resourceBundleFileNameHelper.getLocale());
            }).forEach(bundleName -> neptuneBundleNameMaps.put(bundleName, ""));
            stringBuilder.append(this.getJsonStringFromMap(neptuneBundleNameMaps));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to genarate json for neptune setting bundles : " + e.getMessage()));
            this.logger.debug((Object)e);
        }
        return stringBuilder.toString();
    }

    private Map<String, String> buildBundlesMap(ResourceBundle bundle) {
        HashMap bundlesMap = Maps.newHashMap();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            bundlesMap.put(key, bundle.getString(key));
        }
        return bundlesMap;
    }

    private String getResourceBundleJson(ResourceBundle bundle, Map<String, String> bundlesMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String varName = "";
        try {
            varName = this.normalizeJavascriptVariableName(bundle.getBaseBundleName());
            stringBuilder.append("var " + varName + "_" + bundle.getLocale().toString() + " = ");
            stringBuilder.append(this.getJsonStringFromMap(bundlesMap));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to genarate json for resource bundle : " + varName + "_" + bundle.getLocale().toString() + ", " + e.getMessage()));
            this.logger.debug((Object)e);
        }
        return stringBuilder.toString();
    }

    String normalizeJavascriptVariableName(String variableName) {
        return variableName.replace("-", "___");
    }
}

