/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.i18n.service.bundle;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.tandbergtv.neptune.i18n.common.MessageBundle;
import com.tandbergtv.neptune.i18n.service.I18nResourceServiceDelegate;
import com.tandbergtv.neptune.i18n.service.bundle.FileResourceBundle;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynamicMessageBundleImpl
implements MessageBundle {
    private static final String SETTINGS_GROUP_NAME = "settings";
    private I18nResourceServiceDelegate i18nResourceServiceDelegate;
    private Logger logger = Logger.getLogger(DynamicMessageBundleImpl.class);

    public DynamicMessageBundleImpl(I18nResourceServiceDelegate i18nResourceServiceDelegate) {
        this.i18nResourceServiceDelegate = i18nResourceServiceDelegate;
    }

    @Override
    public String getMessageValue(String key, String propertiesGroup, String defaultValue) {
        return this.getMessageValue(key, propertiesGroup, defaultValue, Locale.getDefault());
    }

    @Override
    public Map<String, String> getAllLocaleMap() {
        return this.i18nResourceServiceDelegate.getAvailableLanguageMap();
    }

    @Override
    public String getMessageValue(String key, String propertiesGroup, String defaultValue, Locale locale, Object ... arguments) {
        String messageValue = this.getMessageValue(key, propertiesGroup, defaultValue, locale);
        return MessageFormat.format(messageValue, arguments);
    }

    @Override
    public String getMessageValue(String key, String propertiesGroup, String defaultValue, Locale locale) {
        if (I18nLocaleUtil.getDefaultLocale().equals(locale)) {
            return defaultValue;
        }
        if (propertiesGroup.equals(SETTINGS_GROUP_NAME)) {
            return this.getMessageValueForNeptuneSettingsGroup(key, defaultValue, locale);
        }
        return this.getMessageValueForRegularGroup(key, propertiesGroup, defaultValue, locale);
    }

    private String getMessageValueForRegularGroup(String key, String propertiesGroup, String defaultValue, Locale locale) {
        String messageValue = null;
        try {
            messageValue = FileResourceBundle.getBundleByParameter(propertiesGroup, locale).getString(key);
        }
        catch (MissingResourceException e) {
            this.logger.debug((Object)("Getting value of key " + key + " at group " + propertiesGroup + " failed\uff1a"), (Throwable)e);
        }
        return messageValue == null ? defaultValue : messageValue;
    }

    private String getMessageValueForNeptuneSettingsGroup(String key, String defaultValue, Locale locale) {
        Set<String> neptuneSettingBundleNames = this.i18nResourceServiceDelegate.getNeptuneSettingMappingBundleNames();
        for (String bundleName : neptuneSettingBundleNames) {
            try {
                if (!bundleName.contains(locale.toString())) continue;
                String message = FileResourceBundle.getBundleByBundleName(bundleName).getString(key);
                this.logger.debug((Object)("neptune setting key " + key + " found in bundle " + bundleName));
                return message;
            }
            catch (MissingResourceException e) {
                this.logger.warn((Object)("neptune setting key " + key + " could not be found in bundle " + bundleName + ", continue to next bundle: "), (Throwable)e);
            }
        }
        return defaultValue;
    }
}

