/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.http.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class ResettableServletRequestWrapper
extends ServletRequestWrapper {
    private byte[] copyOfData;
    private ServletRequest copyOfRequest;
    private ResettableInputStreamDelegate servletStreamDelegate;

    public ResettableServletRequestWrapper(ServletRequest originalRequest) {
        super(originalRequest);
        this.copyOfRequest = originalRequest;
        this.resetInputStream();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.copyOfData == null) {
            this.copyOfData = IOUtils.toByteArray((Reader)this.copyOfRequest.getReader());
            this.servletStreamDelegate.setInputStream(new ByteArrayInputStream(this.copyOfData));
        }
        return this.servletStreamDelegate;
    }

    public BufferedReader getReader() throws IOException {
        if (this.copyOfData == null) {
            this.copyOfData = IOUtils.toByteArray((Reader)this.copyOfRequest.getReader());
            this.servletStreamDelegate.setInputStream(new ByteArrayInputStream(this.copyOfData));
        }
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.servletStreamDelegate)));
    }

    public void resetInputStream() {
        if (this.copyOfData == null) {
            this.servletStreamDelegate = new ResettableInputStreamDelegate();
        }
        this.servletStreamDelegate = new ResettableInputStreamDelegate(new ByteArrayInputStream(this.copyOfData));
    }

    private class ResettableInputStreamDelegate
    extends ServletInputStream {
        private InputStream inputStream;

        public ResettableInputStreamDelegate() {
        }

        public ResettableInputStreamDelegate(InputStream input) {
            this.inputStream = input;
        }

        public void setInputStream(InputStream input) {
            this.inputStream = input;
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }
    }
}

