/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.i18n;

import com.ericsson.neptune.i18n.ThreadScopeLocaleHolder;
import com.tandbergtv.neptune.i18n.service.I18nResourceService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class I18nLocaleUtil {
    private static final Logger LOGGER = Logger.getLogger(I18nLocaleUtil.class);
    public static final String DEFAULT_LOCALE = "en_US";
    public static final String DEFAULT_LOCALE_KEY = "locale";
    public static final String STRUTS_LOCALE_KEY = "org.apache.struts.action.LOCALE";
    public static final String SPRING_LOCALE_SESSION_ATTRIBUTE_NAME = "SessionLocaleResolver.LOCALE";
    public static final String I18N_SERVICE_KEY = "com.tandbergtv.neptune.i18n.service.I18nResourceService";
    private static final String SESSION_MUTEX_ATTRIBUTE = "org.springframework.web.util.WebUtils.MUTEX";

    private I18nLocaleUtil() {
    }

    public static Locale getDefaultLocale() {
        return Locale.US;
    }

    public static Locale toLocale(String localeStr) {
        Locale locale = I18nLocaleUtil.getDefaultLocale();
        try {
            locale = LocaleUtils.toLocale((String)localeStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug((Object)("Invalid locale: " + e.getMessage() + "\n Fall back to default locale: " + DEFAULT_LOCALE), (Throwable)e);
        }
        return locale;
    }

    public static Locale readLocaleSafely(Cookie localeCookie) {
        Locale locale = I18nLocaleUtil.getDefaultLocale();
        if (localeCookie != null && StringUtils.isNotEmpty((String)localeCookie.getValue())) {
            locale = I18nLocaleUtil.toLocale(localeCookie.getValue());
        }
        return locale;
    }

    public static boolean validateLocale(Set<String> providedLocales, String localeValue) {
        if (StringUtils.isBlank((String)localeValue) || providedLocales == null) {
            return false;
        }
        try {
            LocaleUtils.toLocale((String)localeValue);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug((Object)("Invalid locale: " + e.getMessage()));
            return false;
        }
        return providedLocales.contains(localeValue);
    }

    public static Map<String, String> getLocaleMap(I18nResourceService service) {
        Map<Object, Object> localeMap = new HashMap();
        if (service != null && service.getAvailableLanguageMap() != null) {
            localeMap = service.getAvailableLanguageMap();
        } else {
            LOGGER.warn((Object)("Got null " + I18nResourceService.class.getName()));
        }
        if (!localeMap.containsKey(DEFAULT_LOCALE)) {
            localeMap.put(DEFAULT_LOCALE, "English - United States");
        }
        LOGGER.debug((Object)("Available locale: " + localeMap.toString()));
        return localeMap;
    }

    public static Cookie getCookie(Cookie[] cookies, String name) {
        if (cookies == null) {
            return null;
        }
        Optional<Cookie> match = Arrays.asList(cookies).stream().filter(c -> name.equals(c.getName())).findFirst();
        return match.isPresent() ? match.get() : null;
    }

    public static Object getSessionMutex(HttpSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null");
        }
        Object mutex = session.getAttribute(SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session;
        }
        return mutex;
    }

    public static String getThreadScopeLocaleValue() {
        return ThreadScopeLocaleHolder.getInstance().getThreadScopeLocaleValue();
    }

    public static Locale getThreadScopeLocale() {
        return I18nLocaleUtil.toLocale(I18nLocaleUtil.getThreadScopeLocaleValue());
    }
}

