/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JSONToMapConverter {
    private static final String ARRAY_CLOSE = "]";
    private static final String ARRAY_OPEN = "[";
    private static final String SETTING_PATH_SEPARATOR = ".";
    private Map<String, String> values;
    private JsonNode jsonRoot;

    public JSONToMapConverter(JsonNode jsonRoot) {
        this.jsonRoot = jsonRoot;
        this.values = new HashMap<String, String>();
    }

    public Map<String, String> convert() {
        this.convert(null, this.jsonRoot);
        return this.values;
    }

    protected void convert(String parentPath, JsonNode parent) {
        if (parent.isObject() || parent.isArray()) {
            Iterator iterator = parent.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String currentPath = parentPath;
                currentPath = currentPath == null ? (String)entry.getKey() : currentPath + SETTING_PATH_SEPARATOR + (String)entry.getKey();
                if (((JsonNode)entry.getValue()).isArray()) {
                    ArrayNode array = (ArrayNode)entry.getValue();
                    for (int i = 0; i < array.size(); ++i) {
                        this.convert(currentPath + ARRAY_OPEN + i + ARRAY_CLOSE, array.get(i));
                    }
                    continue;
                }
                this.convert(currentPath, (JsonNode)entry.getValue());
            }
        } else if (parentPath != null) {
            this.values.put(parentPath, parent.textValue());
        }
    }
}

