/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.settings.validator;

import com.ericsson.neptune.i18n.I18nLocaleUtil;
import com.ericsson.neptune.i18n.util.ServiceMessageBundleUtil;
import com.tandbergtv.neptune.configuration.settings.entity.LocalizedString;
import com.tandbergtv.neptune.configuration.settings.entity.SettingDefinition;
import com.tandbergtv.neptune.configuration.settings.validator.SettingValidator;
import com.tandbergtv.neptune.configuration.settings.validator.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public abstract class AbstractSettingValidator
implements SettingValidator {
    protected static ResourceBundle defaultMessageBundle = ResourceBundle.getBundle("com.tandbergtv.neptune.configuration.settings.validator.ValidatorMessages");
    protected Map<String, String> validatorParameters;
    protected Map<String, String> otherSettingsValues;
    private static final ValidationResult SUCCESS_VALIDATION_RESULT = new ValidationResult().success();

    @Override
    public void setValidatorParameters(Map<String, String> validatorParameters) {
        this.validatorParameters = validatorParameters;
    }

    @Override
    public void setOtherSettingsValues(Map<String, String> otherSettingsValues) {
        this.otherSettingsValues = otherSettingsValues;
    }

    protected ValidationResult getFailValidationResultWithLocalKey(SettingDefinition setting, String localKey) {
        String currentLocal = this.getCurrentLocal();
        ValidationResult result = new ValidationResult();
        ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
        String diplayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocal);
        params.add(ServiceMessageBundleUtil.createLocalizedParam(diplayName));
        String message = ServiceMessageBundleUtil.getAdminLocaleValue(localKey, defaultMessageBundle.getString(localKey), currentLocal, diplayName);
        return result.addMessage(message, currentLocal, params).fail();
    }

    protected ValidationResult getFailValidationResultWithMessage(SettingDefinition setting, String message) {
        ValidationResult result = new ValidationResult();
        String currentLocal = this.getCurrentLocal();
        ArrayList<List<LocalizedString>> params = new ArrayList<List<LocalizedString>>();
        String diplayName = ServiceMessageBundleUtil.getSettingsLocaleDiplayName(setting.getPath(), setting.getDisplayName().get(0).getValue(), currentLocal);
        params.add(ServiceMessageBundleUtil.createLocalizedParam(diplayName));
        return result.addMessage(message, currentLocal, params).fail();
    }

    protected ValidationResult getSuccessValidationResult() {
        return SUCCESS_VALIDATION_RESULT;
    }

    protected String getCurrentLocal() {
        return I18nLocaleUtil.getThreadScopeLocaleValue();
    }
}

